/********************************************************************** 
 * Copyright (c) 2005 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: SecureFileServerParametersLegacy.java,v 1.1 2005/05/05 20:04:37 samwai Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/

package org.eclipse.hyades.internal.collection.framework;

import org.eclipse.hyades.execution.security.IConnectionHandler;

/**
 * 
 * This class overrides the getConnectionHandler method of SecureServer and
 * returns an new file connection handler class for handling connections
 * 
 * @author Giridhar S
 */
public class SecureFileServerParametersLegacy extends SecureServer {

    /* A file connection handler object */
    private IConnectionHandler fileConnectionHandler;

    public IConnectionHandler getConnectionHandler() {

        if (fileConnectionHandler == null)
            fileConnectionHandler = new FileConnectionHandlerImpl();

        return fileConnectionHandler;
    }
}