/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SecureServer.java,v 1.5 2005/05/16 23:49:31 jptoomey Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.internal.collection.framework;

import java.security.Provider;

import org.eclipse.hyades.execution.security.IConnectionHandler;
import org.eclipse.hyades.execution.security.IKeystoreManager;
import org.eclipse.hyades.execution.security.ISecureServerParameters;

/**
 * @author rduggan
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class SecureServer implements ISecureServerParameters {
	private int port;
	private boolean clientAuthenticationRequired;
	private String keystoreFile;
	private String keystorePassword;
	private Provider provider;
	private IKeystoreManager manager;
	IConnectionHandler connectionHandler;
	
	private String[] ciphers, protos;

	/**
	 * 
	 */
	public SecureServer() {
		super();
	}

	/**
	 * @see org.eclipse.hyades.execution.security.ISecureServerParameters#getPort()
	 */
	public int getPort() {		
		return port;
	}
	

	/**
	 * @see org.eclipse.hyades.execution.security.ISecureServerParameters#clientAuthenticationRequired()
	 */
	public boolean clientAuthenticationRequired() {
		return clientAuthenticationRequired;
	}

	/**
	 * @see org.eclipse.hyades.execution.security.ISecureServerParameters#getSecurityProvider()
	 */
	public Provider getSecurityProvider() {
		return provider;
	}

	/**
	 * @see org.eclipse.hyades.execution.security.ISecureServerParameters#getConnectionHandler()
	 */
	public IConnectionHandler getConnectionHandler() {
		if(connectionHandler==null) {
			connectionHandler = new ConnectionHandlerImpl(); 
		}
		return connectionHandler ;
	}

	/**
	 * @see org.eclipse.hyades.execution.security.ISecureServerParameters#getKeystoreFileName()
	 */
	public String getKeystoreFileName() {
		return keystoreFile;
	}

	/**
	 * @see org.eclipse.hyades.execution.security.ISecureServerParameters#getKeystoreFilepassword()
	 */
	public String getKeystoreFilepassword() {
		return keystorePassword;
	}

	/**
	 * @see org.eclipse.hyades.execution.security.ISecureServerParameters#getKeystoreManager()
	 */
	public IKeystoreManager getKeystoreManager() {
		return manager;
	}

	/**
	 * @see org.eclipse.hyades.execution.security.ISecureServerParameters#getEnabledCypherSuites()
	 */
	public String[] getEnabledCipherSuites() {
		return ciphers;
	}

	/**
	 * @see org.eclipse.hyades.execution.security.ISecureServerParameters#getEnabledProtocols()
	 */
	public String[] getEnabledProtocols() {
		return protos;
	}
	
	public void setPort(int port) {
		this.port=port;
	}
	
	public void setClientAuthenticationRequired(boolean clientAuthenticationRequired) {
		this.clientAuthenticationRequired=clientAuthenticationRequired;
	}
	
	public void setKeystoreFile(String name) {
		keystoreFile=name;
	}
	
	public void setKeystorePassword(String password) {
		keystorePassword=password;
	}
	
	public void setSecurityProvider(String name) throws ClassNotFoundException, IllegalAccessException, InstantiationException{
		Class clazz=Class.forName(name);
		provider=(Provider)clazz.newInstance();
	}
	
	public void setKeystoreManager(String name) throws ClassNotFoundException, IllegalAccessException, InstantiationException{
		Class clazz=Class.forName(name);
		manager=(IKeystoreManager)clazz.newInstance();
	}
	
	public void setCipherSuites(String[] ciphers) {
		if(ciphers!=null) {
			for(int i=0;i<ciphers.length;i++) {
				ciphers[i]=ciphers[i].trim();
				//System.out.println(ciphers[i]);
			}
		}
		this.ciphers=ciphers;
	}
	
	public void setProtocols(String[] protos) {
		if(protos!=null) {
			for(int i=0;i<protos.length;i++) {
				protos[i]=protos[i].trim();
				//System.out.println(protos[i]);
			}
		}
		this.protos=protos;
	}

}
