/**********************************************************************
Copyright (c) 2005 IBM Corporation and others.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Eclipse Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/epl-v10.html
$Id: PlatformObject.java,v 1.6 2005/06/13 16:56:00 samwai Exp $

Contributors:
 IBM Rational - initial implementation
**********************************************************************/
package org.eclipse.hyades.internal.config.generator;

import java.io.File;

public class PlatformObject {
	public final static String name = System.getProperty("os.name", "Unknown");
	public final static String sr = File.separator;
	public final static String pr = File.pathSeparator;
	public final static String encoding = getEncoding();
	public final static String libEnv = getLibEnv();
	public final static String libPath = getLibPath();
	public final static String exeExt = getExeExt();
	public final static String dataSize = getDataSize();
	public final static String tempDir = ConfigUtility.removeTrailings(System.getProperty("java.io.tmpdir", "%RASERVER_HOME%"));
	public final static String jvmLib = getJvmLib();

	private static String getEncoding() {
		if(name.equals("z/OS") || name.equals("OS/390")) {
			return "ibm-1047-s390"; // Bug 99057
		}
		else {
			return "UTF-8";
		}
	}

	private static String getLibEnv() {
		if(name.equals("AIX") || name.equals("OS/400") || name.equals("z/OS") || name.equals("OS/390")) {
			return "LIBPATH";
		}
		else if(name.equals("HP-UX")) {
			return "SHLIB_PATH";
		}
		else if(name.startsWith("Windows")) {
			return "PATH";
		}
		else {
			return "LD_LIBRARY_PATH";
		}
	}

	private static String getLibPath() {
		if(name.startsWith("Windows")) {
			return "bin";
		}
		else {
			return "lib";
		}
	}

	private static String getExeExt() {
		if(name.startsWith("Windows")) {
			return ".exe";
		}
		else {
			return "";
		}
	}

	private static String getDataSize() {
		if(name.startsWith("Windows")) {
			return "64M";
		}
		else {
			return "30M";
		}
	}

	private static String getJvmLib() {
		if(name.startsWith("Windows")) {
			return "jvm.dll";
		}
		else if(name.equals("AIX")) {
			return "libjvm.a";
		}
		else if(name.equals("HP-UX")) {
			return "libjvm.sl";
		}
		else {
			return "libjvm.so";
		}
	}
}
