package org.eclipse.hyades.test;

import java.util.Hashtable;

import org.eclipse.hyades.internal.config.generator.AgentControllerEnvironment;
import org.eclipse.hyades.internal.config.generator.Application;
import org.eclipse.hyades.internal.config.generator.HashUtility;
import org.eclipse.hyades.internal.config.generator.Option;
import org.eclipse.hyades.internal.config.generator.Parameter;
import org.eclipse.hyades.internal.config.generator.PlatformObject;//80294
import org.eclipse.hyades.internal.config.generator.PluginConfig;
import org.eclipse.hyades.internal.config.generator.SetConfigSkeleton;
import org.eclipse.hyades.internal.config.generator.Variable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SetConfig extends SetConfigSkeleton {
	public static String TAG = "org.eclipse.hyades.test";

	public SetConfig() {
		super(TAG);
	}

	public void init(Hashtable hash) {
		String home = HashUtility.getValue(hash, "RASERVER_HOME");
		setFileName(home + sr + "plugins" + sr + TAG + sr + "config" + sr + "pluginconfig.xml");
	}

	public void askUser() {
		// This method is not being used
	}

	public void generateConfiguration() {
		Document doc;
		Element holder;
		Element pConfig;

		Element agent;
		Element aEnv;
		Element app;
		Element option;
		Element param;
		Element var;

		//
		// Standard initializer 
		//
		doc = configFile.getDoc();
		if(doc == null) {
			return;
		}

		pConfig = doc.createElement(PluginConfig.TAG);
		holder = configFile.getHolder();
		holder.appendChild(pConfig);

		//
		// Plugin specific information
		//
		aEnv = doc.createElement(AgentControllerEnvironment.TAG);
		AgentControllerEnvironment.setConfiguration(aEnv, "default");
		pConfig.appendChild(aEnv);

		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH");
		Variable.setPosition(var, "append");
		Variable.setValue(var, "%RASERVER_HOME%" + sr + "plugins" + sr + "org.eclipse.hyades.test" + sr + "lib" + sr + "junit.jar");
		aEnv.appendChild(var);

		app = doc.createElement(Application.TAG);
		Application.setConfiguration(app, "default");
		Application.setExecutable(app, "HyadesTestingSession");
		Application.setLocation(app, (PlatformObject.name.startsWith("Windows") ? "%TEMP%" : "%TMP%"));//80294
		Application.setPath(app, "%JAVA_PATH%");
		pConfig.appendChild(app);

		param = doc.createElement(Parameter.TAG);
		Parameter.setPosition(param, "prepend");
		Parameter.setValue(param, "&quot;-Dhyades.test.JVM=%JAVA_PATH%&quot;");
		app.appendChild(param);
		
		String testLibDir = "%RASERVER_HOME%" + sr + "plugins" + sr + "org.eclipse.hyades.test" + sr + "lib" + sr;

		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH");
		Variable.setPosition(var, "append");
		Variable.setValue(var, testLibDir + "common.runner.jar");
		app.appendChild(var);

		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH");
		Variable.setPosition(var, "append");
		Variable.setValue(var, testLibDir + "hexrecr.jar");
		app.appendChild(var);

		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH");
		Variable.setPosition(var, "append");
		Variable.setValue(var, testLibDir + "http.hexrecr.jar");
		app.appendChild(var);

		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH");
		Variable.setPosition(var, "append");
		Variable.setValue(var, testLibDir + "http.runner.jar");
		app.appendChild(var);

		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH");
		Variable.setPosition(var, "append");
		Variable.setValue(var, testLibDir + "java.runner.jar");
		app.appendChild(var);

		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH");
		Variable.setPosition(var, "append");
		Variable.setValue(var, testLibDir + "manual.runner.jar");
		app.appendChild(var);

		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH");
		Variable.setPosition(var, "append");
		Variable.setValue(var, testLibDir + "common_model.jar");
		app.appendChild(var);

		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH");
		Variable.setPosition(var, "append");
		Variable.setValue(var, testLibDir + "ecore.xmi.jar");
		app.appendChild(var);
		
		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH");
		Variable.setPosition(var, "append");
		Variable.setValue(var, testLibDir + "hmodel.jar");
		app.appendChild(var);
		
		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH");
		Variable.setPosition(var, "append");
		Variable.setValue(var, testLibDir + "runtime.jar");
		app.appendChild(var);
		
		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH");
		Variable.setPosition(var, "append");
		Variable.setValue(var, testLibDir + "datapool_api.jar");
		app.appendChild(var);
		
		//
		// The following can be reused for other plugins
		//
		option = doc.createElement(Option.TAG);
		Option.setName(option, TAG);
		Option.setType(option, "version");
		Option.setValue(option, getString("Config.Plugin.Version"));
		pConfig.appendChild(option);

		configFile.saveToFile();
	}

	public void printHelp() {
	}

	public void printExamples() {
	}
}
