/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IContext.java,v 1.6 2005/02/16 22:20:29 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.logging.adapter;

import java.util.Locale;

/**
 * @author rduggan
 *
 * A specialized IComponent that manages a collection of IComponents
 * as a context.   Contexts exist as separate threads within the Adapter
 * 
 */
public interface IContext extends IComponent, Runnable {
	
	/**
	 * Set the IContextListener that will be invoked as the context
	 * manages its sub-components.  
	 * @param listener
	 */
	public void setContextListener(IContextListener listener);
	
	/**
	 * Get the IContextListener that is invoked as the context
	 * manages its sub-components.  
	 */
	public IContextListener getContextListener();

	/**
	 * Retrieve the locale that this context is operating within
	 * @return
	 */
	public Locale getLocale();
	
	/**
	 * Set the locale to be used by this context
	 * @param locale to be used by the context
	 */
	public void setLocale(Locale locale);
	
	/**
	 * Retrieve the name of the charset that this context is working with
	 * @return
	 */
	public String getCharset();
	
	/**
	 * Set the character set to be used by this context
	 * @param charset the name of the charset to use for this context
	 */
	public void setCharset(String charset);
}
