/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IContextListener.java,v 1.3 2005/02/16 22:20:29 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.logging.adapter;


/**
 * @author rduggan
 *
 * This interface describes the contract between a IContext and a listener
 * that can be configured to be informed of when a subcomponent is invoked
 * by a context object.  
 */
public interface IContextListener  {
	
	/**
	 * Invoked before a sub-component is given a task to process some data.
	 * @param component - the component being invoked
	 * @param msgs - the data that is being given to the component to process
	 */
	public void preProcessEventItems(IComponent component, Object[] msgs);
	
	/**
	 * Invoked after a sub-component is given a task to process some data.
	 * @param component - the component being invoked
	 * @param results - the results that are being returned as a result of
	 * the component processing
	 */
	public void postProcessEventItems(IComponent component, Object[] results);
	
	/**
	 * The contexts which this listener is intended to be informed of events from.
	 * A controller has one or more contexts which zero or more may be listened to.
	 * @return
	 */
	public String[] getTargetContextUniqueIds();

}
