/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IProcessUnit.java,v 1.3 2005/02/16 22:20:29 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.logging.adapter;
import org.eclipse.hyades.logging.adapter.IComponent;
/**
 *
 */
public interface IProcessUnit extends IComponent
{
	/**
	 * Main processing for the processing unit is done by this method.
	 * The contract with the implementation is return an Object[] for further
	 * processing. The array should normally be typed more strongly than Object.
	 * A typical pattern is to implement this method by invoking a more strongly type method.
	 */
	public Object[] processEventItems(Object[] msgs);
	/**
	 * When a context is running, some processing units may decide toe cache or buffer data
	 * for various reasons such as performance. This method provide the behaviour to clear
	 * the content of these buffers. 
	 * For example if a processign unit needs to hold data across calls to the processEventItems
	 * then this method will call final processing of those buffered event. An example is the Extractor
	 * which may need to process mulitple blocks of of data from the Sensor. A flush will
	 * indicate to the Extractor that it is getting no more data and may want to deal with what is has.
	 * A more detailed example would be when data is being processed in a long running
	 * context, the notion of the end of that long runnign process may cause final processing
	 * of buffered data, thus indicating things like end of file for example in a Sensor.
	 */
	public Object[] flushEventItems(Object[] msgs);

	/**
	 * In order to avoid runtime failures a context should invoke this test method.
	 * An implementation should test for the appropriate types it will consume and produce
	 * thus simulating a runtime environment. If a type is not supported an exception should
	 * be thrown.
	 * 
	 */
	public Object[] testProcessEventItems(Object[] msgs) throws AdapterInvalidConfig;
}
