/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ContextFactory.java,v 1.6 2005/02/16 22:20:29 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.logging.adapter.impl;
import org.eclipse.hyades.logging.adapter.internal.util.ComponentLoaderUtil;
import org.eclipse.hyades.logging.adapter.parsers.PreparationException;
import org.eclipse.hyades.logging.adapter.util.Messages;
/**
 * <p>Title: ContextFactory.java</p>
 * <p>Description: Create Context objects
 * </p>
 * @author HS
 * @version 0.1
 **/
public class ContextFactory {
	private ContextFactory() {
	}
	/**
	 * builds context by classname, id , name
	 * @throws org.eclipse.hyades.logging.adapter.parsers.PreparationException if the context cannot be constructed
	 */
	public static Context buildContext(String classname, String id, String name) throws PreparationException {
		Context context = null;
		if (classname != null) {
			try {
				context =(Context) ComponentLoaderUtil.instantiate(classname, "org.eclipse.hyades.logging.adapter.impl.Context");
			}
			catch(PreparationException e) {
				/* Something went wrong building the context.  We need to add some infor to the exception and throw it on up the stack */
            	PreparationException eprime=new PreparationException(Messages.getString("HyadesGAContextInstantiation_ERROR_", name, e.getMessage()));
            	throw eprime;
			}
			context.setName(name);
			context.setUniqueID(id);
		}
		return context;
	}
}
