/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SensorStatus.java,v 1.3 2005/02/16 22:20:29 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.logging.adapter.impl;

/**
 * This class represents the status for a Sensor
 *
 */
public class SensorStatus extends Status {
	/* Total size of the data in the input source that 
	 * the Sensor is reading.
	 */
	private long totalSize = 0;
	
	/* Total size of the data read by the Sensor so far */
	private long processedSize = 0;
	
	/**
	 * @return Returns the processedSize.
	 */
	public long getProcessedSize() {
		return processedSize;
	}
	
	/**
	 * Increment the total processsed size value
	 * @param processedSize The amount to increment processedSize by.
	 */
	public void incrementProcessedSize(long processedSize) {
		this.processedSize += processedSize;
	}
	
	/**
	 * @return Returns the totalSize.
	 */
	public long getTotalSize() {
		return totalSize;
	}
	
	/**
	 * @param totalSize The totalSize to set.
	 */
	public void setTotalSize(long totalSize) {
		this.totalSize = totalSize;
	}
	/**
	 * @param processedSize The processedSize to set.
	 */
	public void setProcessedSize(long processedSize) {
		this.processedSize = processedSize;
	}
}
