/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: CBEHelper.java,v 1.2 2005/03/28 08:38:46 dnsmith Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.logging.adapter.internal.filters;

import java.util.Iterator;
import java.util.List;

import org.eclipse.hyades.logging.adapter.ICBEPropertyConstants;
import org.eclipse.hyades.logging.events.cbe.AvailableSituation;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.ComponentIdentification;
import org.eclipse.hyades.logging.events.cbe.ConfigureSituation;
import org.eclipse.hyades.logging.events.cbe.ConnectSituation;
import org.eclipse.hyades.logging.events.cbe.CreateSituation;
import org.eclipse.hyades.logging.events.cbe.DependencySituation;
import org.eclipse.hyades.logging.events.cbe.DestroySituation;
import org.eclipse.hyades.logging.events.cbe.FeatureSituation;
import org.eclipse.hyades.logging.events.cbe.MsgDataElement;
import org.eclipse.hyades.logging.events.cbe.OtherSituation;
import org.eclipse.hyades.logging.events.cbe.ReportSituation;
import org.eclipse.hyades.logging.events.cbe.RequestSituation;
import org.eclipse.hyades.logging.events.cbe.Situation;
import org.eclipse.hyades.logging.events.cbe.SituationType;
import org.eclipse.hyades.logging.events.cbe.StartSituation;
import org.eclipse.hyades.logging.events.cbe.StopSituation;

/**
 * @author smith
 *
 * This class wraps a CBE and provides the getValueFromPath
 * method to return the value for the specified CBE field
 */
public class CBEHelper implements ICBEPropertyConstants {

	static public String getValueFromPath(CommonBaseEvent cbe, List path) throws InvalidAttributeNameException {
		if (cbe == null | path == null) {
			return null;
		}
		
		Iterator i = path.iterator();
		
		if (path.isEmpty() || !i.next().equals(COMMONBASEEVENT)) {
			throw new InvalidAttributeNameException();
		}
		
		if (i.hasNext()) {
			String node = (String)i.next();
			
			if (node.equals(COMMONBASEEVENT_CREATIONTIME)) {
				return cbe.getCreationTime();
			} else if (node.equals(COMMONBASEEVENT_ELAPSEDTIME)) {
				return String.valueOf(cbe.getElapsedTime());
			} else if (node.equals(COMMONBASEEVENT_EXTENSIONNAME)) {
				return cbe.getExtensionName();
			} else if (node.equals(COMMONBASEEVENT_GLOBALINSTANCEID)) {
				return cbe.getGlobalInstanceId();
			} else if (node.equals(COMMONBASEEVENT_LOCALINSTANCEID)) {
				return cbe.getLocalInstanceId();
			} else if (node.equals(COMMONBASEEVENT_MSG)) {
				return cbe.getMsg();
			} else if (node.equals(COMMONBASEEVENT_PRIORITY)) {
				return String.valueOf(cbe.getPriority());	
			} else if (node.equals(COMMONBASEEVENT_REPEATCOUNT)) {
				return String.valueOf(cbe.getRepeatCount());
			} else if (node.equals(COMMONBASEEVENT_SEQUENCENUMBER)) {
				return String.valueOf(cbe.getSequenceNumber());
			} else if (node.equals(COMMONBASEEVENT_SEVERITY)) {
				return String.valueOf(cbe.getSeverity());
			} else if (node.equals(COMMONBASEEVENT_VERSION)) {
				return cbe.getVersion();
			} else if (node.equals(COMMONBASEEVENT_ASSOCIATEDEVENTS)) {
				if (!i.hasNext()) {
					return null;
				}
				else {
					/*
					 * TODO Handle the associated events properly
					 */
					String nextNode = (String)i.next();
					if (nextNode.equals(ASSOCIATEDEVENT_ASSOCIATIONENGINEREFERENCE)) {
						
					} else if (nextNode.equals(ASSOCIATEDEVENT_ASSOCIATIONENGINEINFO)) {
						
					} else if (nextNode.equals(ASSOCIATEDEVENT_RESOLVEDEVENT)) {
						
					}
					else {
						return null;
					}
					return null;
				}
			} else if (node.equals(COMMONBASEEVENT_CONTEXTDATAELEMENTS)) {
				if (!i.hasNext()) {
					return null;
				}
				else {
					/*
					 * TODO Handle the Context Data elements properly
					 */
					String nextNode = (String)i.next();
					if (nextNode.equals(CONTEXTDATAELEMENT_CONTEXTID)) {
						
					} else if (nextNode.equals(CONTEXTDATAELEMENT_NAME)) {
						
					} else if (nextNode.equals(CONTEXTDATAELEMENT_TYPE)) {
						
					} else if (nextNode.equals(CONTEXTDATAELEMENT_CONTEXTVALUE)) {
						
					} else {
						return null;
					}
					return null;
				}
			} else if (node.equals(COMMONBASEEVENT_EXTENDEDDATAELEMENTS)) {
				/*
				 * TODO Handle the extended data elements properly
				 */
				List edeList = cbe.getExtendedDataElements();
				
				if (i.hasNext() && !edeList.isEmpty()) {
					return null;
				}
				return null;
			} else if (node.equals(COMMONBASEEVENT_MSGDATAELEMENT)) {
				MsgDataElement mde = cbe.getMsgDataElement();
				
				if (i.hasNext() && mde != null) {
					String nextNode = (String)i.next();
					if (nextNode.equals(MSGDATAELEMENT_MSGID)) {
						return mde.getMsgId();
					} else if (nextNode.equals(MSGDATAELEMENT_MSGIDTYPE)) {
						return mde.getMsgIdType();
					} else if (nextNode.equals(MSGDATAELEMENT_MSGCATALOG)) {
						return mde.getMsgCatalog();
					} else if (nextNode.equals(MSGDATAELEMENT_MSGCATALOGID)) {
						return mde.getMsgCatalogId();
					} else if (nextNode.equals(MSGDATAELEMENT_MSGCATALOGTOKENS)) {
						String [] tokenArray = mde.getMsgCatalogTokensAsStrings();
						/*
						 * TODO Handle the array properly
						 */
						return tokenArray[0];
					} else if (nextNode.equals(MSGDATAELEMENT_MSGCATALOGTYPE)) {
						return mde.getMsgCatalogType();
					} else if (nextNode.equals(MSGDATAELEMENT_MSGLOCALE)) {
						return mde.getMsgLocale();
					} 
				}
				return null;
			} else if (node.equals(COMMONBASEEVENT_OTHERDATA)) {
				/*
				 * TODO Handle other data properly
				 */
				if (!i.hasNext()) {
					return null;
				}
				else {
					return null;
				}
			} else if (node.equals(COMMONBASEEVENT_REPORTERCOMPONENTID) ||
					node.equals(COMMONBASEEVENT_SOURCECOMPONENTID)) {
				ComponentIdentification cid;
				if (node.equals(COMMONBASEEVENT_REPORTERCOMPONENTID)) {
					cid = cbe.getReporterComponentId();
				}
				else {
					cid = cbe.getSourceComponentId();
				}
				
				if (i.hasNext() && cid != null) {
					String nextNode = (String)i.next();
					if (nextNode.equals(COMPONENTID_APPLICATION)) {
						return cid.getApplication();
					} else if (nextNode.equals(COMPONENTID_COMPONENT)) {
						return cid.getComponent();
					} else if (nextNode.equals(COMPONENTID_COMPONENTIDTYPE)) {
						return cid.getComponentIdType();
					} else if (nextNode.equals(COMPONENTID_COMPONENTTYPE)) {
						return cid.getComponentType();
					} else if (nextNode.equals(COMPONENTID_EXECUTIONENVIRONMENT)) {
						return cid.getExecutionEnvironment();
					} else if (nextNode.equals(COMPONENTID_INSTANCEID)) {
						return cid.getInstanceId();
					} else if (nextNode.equals(COMPONENTID_LOCATION)) {
						return cid.getLocation();
					} else if (nextNode.equals(COMPONENTID_LOCATIONTYPE)) {
						return cid.getLocationType();
					} else if (nextNode.equals(COMPONENTID_PROCESSID)) {
						return cid.getProcessId();
					} else if (nextNode.equals(COMPONENTID_SUBCOMPONENT)) {
						return cid.getSubComponent();
					} else if (nextNode.equals(COMPONENTID_THREADID)) {
						return cid.getThreadId();
					} 
				}
				return null;
			} else if (node.equals(COMMONBASEEVENT_SITUATION)) {
				Situation sit = cbe.getSituation();
				// Get the Situation data
				if (i.hasNext() && sit != null) {
					String sitNode = (String)i.next();
					if (sitNode.equals(SITUATION_CATEGORYNAME)) {
						return sit.getCategoryName();
					} else if (sitNode.equals(SITUATION_SITUATIONTYPE)) {
						return null;
					} else if (sitNode.equals(AVAILABLESITUATION)) {
						SituationType sitType = sit.getSituationType();
						if (i.hasNext() && sitType instanceof AvailableSituation) {
							AvailableSituation realSitType = (AvailableSituation)sitType;
							String sitAttrNode = (String)i.next();
							if (sitAttrNode.equals(SITUATIONTYPE_REASONINGSCOPE)) {
								return realSitType.getReasoningScope();
							}
							else if (sitAttrNode.equals(AVAILABLESITUATION_OPERATIONDISPOSITION)) {
								return realSitType.getOperationDisposition();
							}
							else if (sitAttrNode.equals(AVAILABLESITUATION_PROCESSINGDISPOSITION)) {
								return realSitType.getProcessingDisposition();
							}
							else if (sitAttrNode.equals(AVAILABLESITUATION_AVAILABILITYDISPOSITION)) {
								return realSitType.getAvailabilityDisposition();
							}
						}
					} else if (sitNode.equals(REQUESTSITUATION)) {
						SituationType sitType = sit.getSituationType();
						if (i.hasNext() && sitType instanceof RequestSituation) {
							RequestSituation realSitType = (RequestSituation)sitType;
							String sitAttrNode = (String)i.next();
							if (sitAttrNode.equals(SITUATIONTYPE_REASONINGSCOPE)) {
								return realSitType.getReasoningScope();
							}
							else if (sitAttrNode.equals(SITUATIONTYPE_SUCCESSDISPOSITION)) {
								return realSitType.getSuccessDisposition();
							}
							else if (sitAttrNode.equals(SITUATIONTYPE_SITUATIONQUALIFIER)) {
								return realSitType.getSituationQualifier();
							}
						}
					} else if (sitNode.equals(STARTSITUATION)) {
						SituationType sitType = sit.getSituationType();
						if (i.hasNext() && sitType instanceof StartSituation) {
							StartSituation realSitType = (StartSituation)sitType;
							String sitAttrNode = (String)i.next();
							if (sitAttrNode.equals(SITUATIONTYPE_REASONINGSCOPE)) {
								return realSitType.getReasoningScope();
							}
							else if (sitAttrNode.equals(SITUATIONTYPE_SUCCESSDISPOSITION)) {
								return realSitType.getSuccessDisposition();
							}
							else if (sitAttrNode.equals(SITUATIONTYPE_SITUATIONQUALIFIER)) {
								return realSitType.getSituationQualifier();
							}
						}
					} else if (sitNode.equals(STOPSITUATION)) {
						SituationType sitType = sit.getSituationType();
						if (i.hasNext() && sitType instanceof StopSituation) {
							StopSituation realSitType = (StopSituation)sitType;
							String sitAttrNode = (String)i.next();
							if (sitAttrNode.equals(SITUATIONTYPE_REASONINGSCOPE)) {
								return realSitType.getReasoningScope();
							}
							else if (sitAttrNode.equals(SITUATIONTYPE_SUCCESSDISPOSITION)) {
								return realSitType.getSuccessDisposition();
							}
							else if (sitAttrNode.equals(SITUATIONTYPE_SITUATIONQUALIFIER)) {
								return realSitType.getSituationQualifier();
							}
						}
					} else if (sitNode.equals(CONFIGURESITUATION)) {
						SituationType sitType = sit.getSituationType();
						if (i.hasNext() && sitType instanceof ConfigureSituation) {
							ConfigureSituation realSitType = (ConfigureSituation)sitType;
							String sitAttrNode = (String)i.next();
							if (sitAttrNode.equals(SITUATIONTYPE_REASONINGSCOPE)) {
								return realSitType.getReasoningScope();
							}
							else if (sitAttrNode.equals(SITUATIONTYPE_SUCCESSDISPOSITION)) {
								return realSitType.getSuccessDisposition();
							}
						}
					} else if (sitNode.equals(CREATESITUATION)) {
						SituationType sitType = sit.getSituationType();
						if (i.hasNext() && sitType instanceof CreateSituation) {
							CreateSituation realSitType = (CreateSituation)sitType;
							String sitAttrNode = (String)i.next();
							if (sitAttrNode.equals(SITUATIONTYPE_REASONINGSCOPE)) {
								return realSitType.getReasoningScope();
							}
							else if (sitAttrNode.equals(SITUATIONTYPE_SUCCESSDISPOSITION)) {
								return realSitType.getSuccessDisposition();
							}
						}
					} else if (sitNode.equals(DESTROYSITUATION)) {
						SituationType sitType = sit.getSituationType();
						if (i.hasNext() && sitType instanceof DestroySituation) {
							DestroySituation realSitType = (DestroySituation)sitType;
							String sitAttrNode = (String)i.next();
							if (sitAttrNode.equals(SITUATIONTYPE_REASONINGSCOPE)) {
								return realSitType.getReasoningScope();
							}
							else if (sitAttrNode.equals(SITUATIONTYPE_SUCCESSDISPOSITION)) {
								return realSitType.getSuccessDisposition();
							}
						}
					} else if (sitNode.equals(CONNECTSITUATION)) {
						SituationType sitType = sit.getSituationType();
						if (i.hasNext() && sitType instanceof ConnectSituation) {
							ConnectSituation realSitType = (ConnectSituation)sitType;
							String sitAttrNode = (String)i.next();
							if (sitAttrNode.equals(SITUATIONTYPE_REASONINGSCOPE)) {
								return realSitType.getReasoningScope();
							}
							else if (sitAttrNode.equals(SITUATIONTYPE_SUCCESSDISPOSITION)) {
								return realSitType.getSuccessDisposition();
							}
							else if (sitAttrNode.equals(CONNECTSITUATION_SITUATIONDISPOSITION)) {
								return realSitType.getSituationDisposition();
							}
						}	
					} else if (sitNode.equals(REPORTSITUATION)) {
						SituationType sitType = sit.getSituationType();
						if (i.hasNext() && sitType instanceof ReportSituation) {
							ReportSituation realSitType = (ReportSituation)sitType;
							String sitAttrNode = (String)i.next();
							if (sitAttrNode.equals(SITUATIONTYPE_REASONINGSCOPE)) {
								return realSitType.getReasoningScope();
							}
							else if (sitAttrNode.equals(REPORTSITUATION_REPORTCATEGORY)) {
								return realSitType.getReportCategory();
							}
						}
					} else if (sitNode.equals(FEATURESITUATION)) {
						SituationType sitType = sit.getSituationType();
						if (i.hasNext() && sitType instanceof FeatureSituation) {
							FeatureSituation realSitType = (FeatureSituation)sitType;
							String sitAttrNode = (String)i.next();
							if (sitAttrNode.equals(SITUATIONTYPE_REASONINGSCOPE)) {
								return realSitType.getReasoningScope();
							}
							else if (sitAttrNode.equals(FEATURESITUATION_FEATUREDISPOSITION)) {
								return realSitType.getFeatureDisposition();
							}
						}
					} else if (sitNode.equals(DEPENDENCYSITUATION)) {
						SituationType sitType = sit.getSituationType();
						if (i.hasNext() && sitType instanceof DependencySituation) {
							DependencySituation realSitType = (DependencySituation)sitType;
							String sitAttrNode = (String)i.next();
							if (sitAttrNode.equals(SITUATIONTYPE_REASONINGSCOPE)) {
								return realSitType.getReasoningScope();
							}
							else if (sitAttrNode.equals(DEPENDENCYSITUATION_DEPENDENCYDISPOSITION)) {
								return realSitType.getDependencyDisposition();
							}
						}
					} else if (sitNode.equals(OTHERSITUATION)) {
						SituationType sitType = sit.getSituationType();
						if (i.hasNext() && sitType instanceof OtherSituation) {
							OtherSituation realSitType = (OtherSituation)sitType;
							String sitAttrNode = (String)i.next();
							if (sitAttrNode.equals(SITUATIONTYPE_REASONINGSCOPE)) {
								return realSitType.getReasoningScope();
							}
							else if (sitAttrNode.equals(OTHERSITUATION_ANYDATA)) {
								return realSitType.getAny();
							}
						}							
					}
					
				}
			}
		}
		throw new InvalidAttributeNameException();
	}
}
