/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: FilterElementImpl.java,v 1.2 2005/03/28 08:38:46 dnsmith Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.logging.adapter.internal.filters;

import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.w3c.dom.Element;

/**
 * @author rduggan
 *
 */
public abstract class FilterElementImpl implements IFilterElement {

	private boolean negated=false;
	private String operator=null;
	
	/**
	 * @see org.eclipse.hyades.logging.adapter.filters.IFilterElement#isNegated()
	 */
	public boolean isNegated() {
		return negated;
	}

	/**
	 * @see org.eclipse.hyades.logging.adapter.filters.IFilterElement#getOperator()
	 */
	public String getOperator() {
		return operator;
	}

	/**
	 * @see org.eclipse.hyades.logging.adapter.filters.IFilterElement#setNegated(boolean)
	 */
	public void setNegated(boolean negated) {
		this.negated=negated;
		
	}

	/**
	 * @see org.eclipse.hyades.logging.adapter.filters.IFilterElement#setOperator(java.lang.String)
	 */
	public void setOperator(String operator) {
		this.operator=operator;
		
	}

	/**
	 * @see org.eclipse.hyades.logging.adapter.filters.IFilterElement#prepareFilter(org.w3c.dom.Node)
	 */
	public void prepareFilter(Element  node) throws AdapterInvalidConfig {
		/* Retrieve the operation */
		operator=node.getAttribute(Messages.getString("HyadesGAOperatorAttributeName"));
		if(operator==null || operator.equals("")) {
			/* We have no operator so throw an exception*/
			throw new AdapterInvalidConfig(Messages.getString("HyadesGAFilter_Preparation_Invalid_Filter_Rule_No_Operator_ERROR_",node.getNodeName()));
		}
		
		/* Retrieve the negation */
		String negation=node.getAttribute(Messages.getString("HyadesGANegationAttributeName"));
		if(negation!=null && negation.equals("true")) {
			this.negated=true;
		}
		else {
			/* We have no negation specified, the default is to have no negation */
			this.negated=false;
		}		
	}
	
	/** 
	 * Indicates whether filtered items need to be cached.
	 * This is an abstract method that must be implemented by subclasses
	 * @return int size of cache
	 */
	public int requiresCache() {
		return 0;
	}
}
