/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IFilterElement.java,v 1.1 2005/03/23 23:37:14 dnsmith Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.logging.adapter.internal.filters;

import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.w3c.dom.Element;

/**
 * @author rduggan
 *
 * This interface represents a generic filter element.
 */
public interface IFilterElement {

	/**
	 * Is this filter element configured to evaluate to its reverse logic.
	 * @return
	 */
	public boolean isNegated();
	
	/**
	 * Set whether this filter element will evaluate to its reverse logic.
	 * @param negated
	 */
	public void setNegated(boolean negated);
	
	/**
	 * Retrieve the logical operator for this filter element.
	 * @return
	 */
	public String getOperator();
	
	/**
	 * Set the logical operator for this filter element
	 * @param operator
	 */
	public void setOperator(String operator);
	
	/**
	 * Prepare this filter element.  The implementation uses the XML document to
	 * determine what its configuration is.
	 * @param node
	 * @throws AdapterInvalidConfig
	 */
	public void prepareFilter(Element node) throws AdapterInvalidConfig;
	
	public boolean evaluateFilter();
}
