/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: StringFilterType.java,v 1.1 2005/03/23 23:37:14 dnsmith Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.logging.adapter.internal.filters;

/**
 * @author smith
 * 
 * This class represents a string filter type.
 */
public class StringFilterType implements IFilterType {

	public static final String EQUALS 		= "equals";
	public static final String STARTS_WITH 	= "startsWith";
	public static final String CONTAINS		="contains";
	public static final String ENDS_WITH	="endsWith";
	
	private static final String[] operands = {CONTAINS, ENDS_WITH, EQUALS, STARTS_WITH};
	
	/**
	 * @see org.eclipse.hyades.logging.adapter.filters.IFilterType#getOperators()
	 */
	public String[] getOperators() {
		return operands;
	}

	/**
	 * @see org.eclipse.hyades.logging.adapter.filters.IFilterType#processRule(java.lang.String, java.lang.String)
	 */
	public boolean processRule(IFilterAtom rule) {
		boolean result=rule.isNegated();
		if (rule.getOperator().equals(CONTAINS)) {
			result=contains(rule.getLeftOperand(), rule.getRightOperand());
		}
		else if (rule.getOperator().equals(ENDS_WITH)) {
			result=endsWith(rule.getLeftOperand(), rule.getRightOperand());
		}
		else if (rule.getOperator().equals(EQUALS)) {
			result=equals(rule.getLeftOperand(), rule.getRightOperand());
		}
		else if (rule.getOperator().equals(STARTS_WITH)) {
			result=startsWith(rule.getLeftOperand(), rule.getRightOperand());
		}
		if(rule.isNegated()) {
			return !result;
		}
		return result;
	}
	
	private boolean equals(String lhs, String rhs) {
		if(lhs.equals(rhs)) {
			return true;
		}
		return false;	
	}
	
	private boolean contains(String lhs, String rhs) {
		int result=lhs.indexOf(rhs);
		if(result!=-1) {
			return true;
		}
		return false;	
	}
	
	private boolean endsWith(String lhs, String rhs) {
		if(lhs.endsWith(rhs)) {
			return true;
		}
		return false;	
	}
	
	private boolean startsWith(String lhs, String rhs) {
		if(lhs.startsWith(rhs)) {
			return true;
		}
		return false;	
	}

}
