package org.eclipse.hyades.logging.adapter.internal.util;

import org.eclipse.hyades.logging.adapter.impl.*;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.impl.SimpleEventFactoryHomeImpl;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AdapterSensor.java,v 1.16 2005/02/16 22:20:29 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
 
 /**
  * A singleton <code>Sensor</code> implementation for logging within the GLA.
  * 
  * 
  * @author Harm Sluiman
  * @author Paul E. Slauenwhite
  * @see org.eclipse.hyades.logging.adapter.impl.Sensor
  * @see org.eclipse.hyades.logging.adapter.impl.ProcessUnit
  */
public class AdapterSensor extends Sensor {
	
	private int arraySize = 256;
	private CommonBaseEvent[] events = new CommonBaseEvent[arraySize];
	private int eventOffset = 0;

	
		
	private static AdapterSensor instance = null;
	
	/**
	 * simulates a getNext
	 * 
	 * @see com.ibm.acad.general.sensor.ISensor#testGetNext()
	 */
	public synchronized Object[] testGetNext() {
		return testGetNextEvent();
	}
	
	/**
	 * implements the testGetNext behaviour by returning a test CBE
	 * 
	 * @return org.eclipse.hyades.logging.events.cbe.CommonBaseEvent[]
	 */
	public synchronized CommonBaseEvent[] testGetNextEvent() {
		CommonBaseEvent[] eventArray = new CommonBaseEvent[1];
		eventArray[0] = new SimpleEventFactoryHomeImpl().getEventFactory("org.eclipse.hyades.logging.adapter.internal.util.AdapterSensor").createCommonBaseEvent();
		return eventArray;
	}
	
	public Object[] flush() {
		return getNext();
	}
	
	public Object[] getNext() {
		return getNextEvent();
	}
	
	public CommonBaseEvent[] getNextEvent() {
		
		/* RKD:  If we don't have any records to return then don't even bother entering the synchronization block.  This should
		 * be safe as the eventsOffset is only changed inside of the synchronization block.
		 */
		if (eventOffset == 0) {
			return null;
		}
		
		synchronized (this) {
			CommonBaseEvent[] outputArray = new CommonBaseEvent[eventOffset];
			System.arraycopy(events, 0, outputArray, 0, eventOffset);
			for (int i = 0; i < eventOffset; i++) {
				events[i] = null;
			}
			incrementItemsProcessedCount(eventOffset);
			eventOffset=0;
			return outputArray;
		}
	}
	
	public Object[] processEventItems(Object[] newEvents) {
		synchronized (this) {
			for(int i=0; i<newEvents.length; i++) {
				if (eventOffset == events.length) {
					CommonBaseEvent[] tempArray = new CommonBaseEvent[arraySize * 2];
					arraySize = arraySize * 2;
					System.arraycopy(events, 0, tempArray, 0, eventOffset);
					events = tempArray;
				}
				events[eventOffset++] = (CommonBaseEvent)newEvents[i];
			}
			return null;
		}
	}
}
