package org.eclipse.hyades.logging.adapter.internal.util;

import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;

import org.eclipse.hyades.logging.events.cbe.ContentHandler;
import org.eclipse.hyades.logging.events.cbe.impl.EventXMLFileEventFactoryHomeImpl;

/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse
 * Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: RuntimeEventXMLFileEventFactoryHomeImpl.java,v 1.5 2005/02/16 22:20:29 qiyanli Exp $
 * 
 * Contributors: IBM - Initial API and implementation
 ******************************************************************************/

/**
 * An extension to the <code>TemplateContentHandlerImpl</code> implementation 
 * provided by the GLA to set run-time configuration data on Common Base Events
 * created for logging.
 * <p>
 * 
 * 
 * @author   Paul E. Slauenwhite
 * @version  January 6, 2005
 * @since    April 9, 2004
 */
public class RuntimeEventXMLFileEventFactoryHomeImpl extends EventXMLFileEventFactoryHomeImpl {

    /**
     * @see org.eclipse.hyades.logging.events.cbe.impl.EventXMLFileEventFactoryHomeImpl#resolveTemplateXMLFileInputStream(java.lang.String)
     */
    public InputStream resolveTemplateXMLFileInputStream(final String fileName) {
        
        InputStream inputStream = null;
        
        if ((fileName != null) && (fileName.trim().length() > 0)) {

            //Attempt to find the EventFactoryHome class using the current class' 
            //(e.g. RuntimeEventXMLFileEventFactoryHomeImpl) class loader to find 
            //the actual local location of the configuration template file 
            //using privileged security:
            try {
                    
            	//Consult the current class' (e.g. RuntimeEventXMLFileEventFactoryHomeImpl) 
                //class loader to find the EventFactoryHome class using privileged security:
                inputStream = ((InputStream) (AccessController.doPrivileged(new PrivilegedExceptionAction() {
                    	
                	public Object run() throws Exception {
                	    return (this.getClass().getClassLoader().getResourceAsStream(fileName));
                	}
                })));
            } 
            catch (Throwable t) {
                    
            	//Ignore since insufficient security privileges for accessing the
                //current class' (e.g. RuntimeEventXMLFileEventFactoryHomeImpl) 
                //class loader and we delegate to the super class' API:
                inputStream = super.resolveTemplateXMLFileInputStream(fileName);                    
            }
        }
               
        return inputStream;
    }
    
    /**
     * @see org.eclipse.hyades.logging.events.cbe.impl.AbstractEventFactoryHome#resolveContentHandler()
     */
    public ContentHandler resolveContentHandler() {
        return (new RuntimeTemplateContentHandlerImpl());
    }
}
