package org.eclipse.hyades.logging.adapter.parsers;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DirectedGraphImpl.java,v 1.6 2005/04/28 20:22:28 dnsmith Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

import org.eclipse.hyades.logging.adapter.IDirectedGraph;

public class DirectedGraphImpl implements IDirectedGraph, Cloneable {
	
	private Object value;
	private List path;

	/**
	 * Default constructor
	 */
	public DirectedGraphImpl() {
		super();
	}

	/**
	 * Create a DirectedGraphImpl object based on a string name
	 * and value.
	 * @param name A period delimited name string representing the path.
	 * @param value The value object.
	 */
	public DirectedGraphImpl(String name, Object value) {
		super();
		path = createPath(name);
		this.value = value;
	}

	/**
	 * Create a DirectedGraphImpl object based on a path list
	 * and value.
	 * @param path A path list.
	 * @param value The value object.
	 */
	public DirectedGraphImpl(List path, Object value) {
		super();
		this.path = path;
		this.value = value;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.logging.adapter.IDirectedGraph#getPath()
	 */
	public List getPath() {
		return path;
	}

	/**
	 * @see org.eclipse.hyades.logging.adapter.IDirectedGraph#setPath(java.util.List)
	 */
	public void setPath(List path) {
		this.path=path;

	}

	/**
	 * @see org.eclipse.hyades.logging.adapter.IDirectedGraph#getValue()
	 */
	public Object getValue() {
		return value;
	}

	/**
	 * @see org.eclipse.hyades.logging.adapter.IDirectedGraph#setValue(java.lang.Object)
	 */
	public void setValue(Object value) {
		this.value=value;

	}
	
	/**
	 * Create a path list from a period delimited string of the form
	 * name1.name2.name3... or
	 * name1[index1].name2[index2].name3[index3]...
	 * The resulting List will contain the indices as well.
	 * 
	 * @param name period delimited string
	 * @return List containing the path.
	 */
	public static List createPath(String name) {
		List path = new ArrayList();
		// Get the tokens delimited by periods
		StringTokenizer s = new StringTokenizer(name, ".");
		
		while (s.hasMoreTokens()) {
			String subPath = s.nextToken();
			int indexStart = subPath.indexOf('[');
			int indexEnd = subPath.indexOf(']');
			// If there is an index add it to the path as well
			if(indexStart>0 && indexEnd > indexStart) {
				String index=subPath.substring(indexStart+1, indexEnd);
				subPath=subPath.substring(0, indexStart);
				path.add(subPath);
				path.add(index);
			}
			else {
				path.add(subPath);
			}
		}
		return path;
	}
} 
