/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IStatement.java,v 1.5 2005/02/16 22:20:29 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.logging.adapter.parsers;

import java.util.HashMap;
import java.util.List;

import org.eclipse.hyades.logging.adapter.AdapterException;
import org.w3c.dom.Element;

/**
 * This is the interface that all processing elements must adhere to.  IStatement
 * instances are first given a piece of configuration via the prepare method.  Once the
 * configuration is prepared then the IProcessingNode will be given requests to analyse a
 * piece of character data against the prepared statement
 * 
 * @author rduggan
 * @version 0.1
 * @since 0.1
 */
public interface IStatement {
	
	/**
	 * Prepare this IStatement for use.  
	 * @param node - the Node from the configuration that this IStatement is
	 *               responsable for handling.
	 */
	public void prepare(Element node, String path) throws PreparationException ;
	
	/**
	 * Run this IStatement against a specific character sequence.
	 * @param line
	 * @param env
	 * @return a list of results due to the run.
	 */
	public List run(String line , HashMap inputs) throws AdapterException, StatementException;
	
	/**
	 * IStatements are organized in a heirarchy and it may be that this IStatement is a required
	 * element for our parent to be valid.
	 * @return is this IStatement required by our parent
	 */
	public boolean isRequiredByParent();
	
	
	/**
	 * IStatements are organized in a heirarchy and it may be that this IStatement can have only one
	 * of its children.
	 * @return whether this IStatement has only one valid child
	 */
	public boolean isChildChoice();
}
