/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ISubstitutionExtension.java,v 1.4 2005/02/16 22:20:29 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.logging.adapter.parsers;

import org.eclipse.hyades.logging.adapter.AdapterException;

/**
 * @author smith
 *
 * This is the interface that will be used to supply external code to the parser
 * component to process all of a record or a portion of a record to generate a
 * parse value for some attribute.  That is, the interface defines an extension
 * to a substitution rule.  The implementation code must be stateless.
 * That is, the caller of the class assumes an object is used for only one record.
 * 
 */
public interface ISubstitutionExtension {

	/**
	 * Process a whole record to generate an attribute value 
	 * @param record - the whole log record
	 * @return String - the generated attribute value
	 */
	public String processRecord(String record) throws AdapterException;

	/**
	 * Process the result of a regular expression match on a record to generate an 
	 * attribute value 
	 * @param result - the regular expression match result
	 * @return String - the generated attribute value
	 */	
	public String processMatchResult(String result) throws AdapterException;
}
