/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: StatementException.java,v 1.3 2005/02/16 22:20:30 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.logging.adapter.parsers;

/**
 * @author rduggan
 *
 * This is a simple exception class to be used by IStatements to determine
 * whether a statement is not a match.  it is implemented as a singleton 
 * as it is not intended to provide failure reasons. This saves the cost 
 * of instantiating an instance without need. 
 */
public class StatementException extends Exception {
	
	/* The singleton instance */
	private static StatementException exception= new StatementException();
	
	/* hide the default constructor */
	private StatementException() {
		
	}
	
	/* Retrieve the singleton instance */
	public static StatementException instance() {
		return exception;
	}

}
