/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AdapterMigrationException.java,v 1.4 2005/02/16 22:20:30 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.logging.adapter.util;

import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;

/**
 * An adapter configuration migration exception
 * 
 */
public class AdapterMigrationException extends AdapterInvalidConfig {

	private String details = null;
	private String elementName;
	private String attributeName;
	/**
	 * 
	 */
	public AdapterMigrationException() {
		super();
	}

	/**
	 * @param message
	 */
	public AdapterMigrationException(String message) {
		super(message);
	}

	/**
	 * @param message
	 * @param cause
	 */
	public AdapterMigrationException(String message, Throwable cause) {
		super(message, cause);
	}

	/**
	 * @param cause
	 */
	public AdapterMigrationException(Throwable cause) {
		super(cause);
	}
	
	public String getDetails() {
		return details;
	}
	
	public void setDetails(String details) {
		this.details=details;
	}
	
	public String getElementName() {
		return elementName;
	}
	
	public void setElementName(String name) {
		elementName=name;
	}
	
	

	/**
	 * @return
	 */
	public String getAttributeName() {
		return attributeName;
	}

	/**
	 * @param string
	 */
	public void setAttributeName(String string) {
		attributeName = string;
	}

}
