package org.eclipse.hyades.logging.adapter.util;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: Messages.java,v 1.6 2005/02/16 22:20:30 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.hyades.logging.adapter.AdapterPlugin;

/**
 * This class contains various operations to retrieved translated messages.
 * 
 * @author rduggan
 * @author paules
 */
public class Messages {

    private static final String RESOURCE_BUNDLE_NAME = "org.eclipse.hyades.logging.adapter.util.properties.plugin";
    private static ResourceBundle resourceBundle = null;

    public static String getString(String key) {

        //Load ResourceBundle:
        if (resourceBundle == null) {

            //Eclipse Resource Bundle:
            try {
                resourceBundle = AdapterPlugin.getResourceBundle();
            }
            catch (Throwable e) {
            }

            //'org.eclipse.hyades.logging.adapter.util.properties.plugin.properties' Resource Bundle:
            if (resourceBundle == null) {
                try {
                    resourceBundle = ResourceBundle.getBundle(RESOURCE_BUNDLE_NAME, Locale.getDefault());
                }
                catch (MissingResourceException m) {

					//Attempt to reload the resource bundle:
					resourceBundle = null;

                    return key;
                }
            }
        }

        try {
            return (resourceBundle.getString(key.trim()).trim());
        }
        catch (Exception e) {
        }

        return key;
    }

    public static String getString(String key, String argument) {
        return (getString(key, new String[] { argument }));
    }

    public static String getString(String key, String argumentA, String argumentB) {
        return (getString(key, new String[] { argumentA, argumentB }));
    }

    public static String getString(String key, String argumentA, String argumentB, String argumentC) {
        return (getString(key, new String[] { argumentA, argumentB, argumentC }));
    }
    
    public static String getString(String key, String argumentA, String argumentB, String argumentC, String argumentD) {
        return (getString(key, new String[] { argumentA, argumentB, argumentC, argumentD }));
    }
    public static String getString(String key, String[] arguments) {
        try {
            return (MessageFormat.format(getString(key), arguments));
        }
        catch (Exception e) {
            return key;
        }
    }
}
