package org.eclipse.hyades.logging.adapter.util;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TimeParser.java,v 1.6 2005/02/16 22:20:30 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

import org.eclipse.hyades.logging.adapter.AdapterException;

/**
 * @author GG
 * @version 0.95
 */
public class TimeParser
{

  // contains current format 
  private String format = null;
  // contains current formatter
  private SimpleDateFormat formatter = null;

  //set proper current format and all internal variables
  //for the formatting
  private void setFormat(String _format, Locale locale) throws AdapterException
  {
    if (_format!=null && !_format.equals(format))
	{
    	format = _format.trim();
    	try {
    		formatter = new SimpleDateFormat(format, locale);
    	}
    	catch (IllegalArgumentException e) {
    		// Looks like we have an invalid format specifier - throw an exception
    		throw new AdapterException(e);
    	}
	}
    //To do check pattern
  }

  //public constructor
  public TimeParser(String timeFormat, Locale locale) throws AdapterException
  {
	setFormat(timeFormat, locale);
  }
  
  /**
   * Converts the formatted time string to milliseconds
   * @param strTime
   * @return value of time in milliseconds as a long
   */
  public long parse(String strTime) throws AdapterException
  {
    long ret = 0;
    try
    {
      if (formatter!= null && format != null)
      {
		Date dt = formatter.parse(strTime.trim());
		if (dt != null)
		{
		  ret = dt.getTime();
		}
      }
    }
    catch (Exception ex)
    {
    	throw new AdapterException(Messages.getString("HyadesGA_CBE_Parser_Run_TimeParser_Exception_ERROR_", strTime.trim(), format), ex);
    }
    return ret;
  }
	
}