/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: InsufficientBufferLengthException.java,v 1.4 2005/02/16 22:20:15 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.collection.correlation.exceptions;

/**
 * This exception will be thrown if a given buffer is not sufficiently long for the data to be written.
 * 
 * @author Qiyan Li
 */
public class InsufficientBufferLengthException extends Exception {
	protected int requiredLength; // the length which will prevent the same exception from occurring

    /**
     * Creates a new exception with the required length set.
     * 
     * @param requiredLength    the length which will prevent the same exception from occurring
     */
    public InsufficientBufferLengthException(int requiredLength) {
			this.requiredLength = requiredLength;
	}
	
    /**
     * Returns the required length.
     * 
     * @return  the required length.
     */
	public int getRequiredLength() {
		return requiredLength;
	}
}
