/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TRCNodeHandler.java,v 1.6 2005/02/16 22:20:27 qiyanli Exp $
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.testgen.http;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

import org.eclipse.hyades.internal.execution.testgen.TestgenException;


/**
 * @author dhinson
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class TRCNodeHandler implements ITRCNodeHandler
{
	protected TRCContext context;
	
	public void init (TRCContext context)
		throws TestgenException
	{
		this.context = context;
	}
	
	public void node (TRCNode node)
		throws TestgenException
	{
		// no-op
	}

	//
	// class utility methods
	//
	
	private static final String SPACES  = "          ";

	protected static String getAttributeValue (String name, TRCNode node)
	{
		TRCElement element = node.getElement();
		TRCElement.TRCAttribute [] attributes = element.getAttributes();
		for (int i = 0; i < attributes.length; ++i)
			if (attributes[i].name.equals(name))
				return attributes[i].value;
		return null;
	}
	
	protected static TRCNode getSubNode (String name, TRCNode node)
	{
		ListIterator itr = node.getSubNodes().listIterator();
		TRCNode subNode = null;
		while (itr.hasNext()) {
			subNode = (TRCNode)itr.next();
			if (subNode.getName().equals(name))
				break;
		}
		return subNode;
	}
	
	protected static List getSubNodeList (String name, TRCNode node)
	{
		ArrayList list = new ArrayList();
		ListIterator itr = node.getSubNodes().listIterator();
		while (itr.hasNext()) {
			TRCNode subNode = (TRCNode)itr.next();
			if (subNode.getName().equals(name))
				list.add(subNode);
		}
		return list;
	}
	
	protected static void dumpVertexElementName (PrintStream debugStream, int nSpaces, TRCElement element)
	{
		if (debugStream != null)
			debugStream.println(SPACES.substring(1, nSpaces) + "* [" +
				element.getName() + "]");
	}
	
	protected static void dumpElementName (PrintStream debugStream, int nSpaces, TRCElement element)
	{
		if (debugStream != null)
			debugStream.println(SPACES.substring(1, nSpaces) + "[" +
				element.getName() + "]");
	}
	
	protected static void dumpElementAttributes (PrintStream debugStream, int nSpaces, TRCElement element)
	{
		TRCElement.TRCAttribute [] attributes = element.getAttributes();
		for (int i = 0; i < attributes.length; ++i)
			if (debugStream != null)
				debugStream.println(SPACES.substring(1, nSpaces)+ "([" +
					attributes[i].name + "] = [" + attributes[i].value + "])");
	}

	protected static void dumpElementContent (PrintStream debugStream, int nSpaces, TRCElement element)
	{
		if (debugStream != null)
			debugStream.println(SPACES.substring(1, nSpaces) + "<" +
				element.getContent().trim() + ">");
	}
		
	protected static void dumpFirstOrderSection (PrintStream debugStream, TRCNode topNode)
	{
		if (debugStream != null)
			debugStream.println();
		dumpVertexElementName(debugStream, 2, topNode.getElement());
		dumpElementAttributes(debugStream, 4, topNode.getElement());		
							
		ListIterator itr = topNode.getSubNodes().listIterator();
		while (itr.hasNext()) {
			TRCNode node1 = (TRCNode)itr.next();
			TRCElement element1 = node1.getElement();
								
			dumpElementName(debugStream, 4, element1);
			dumpElementAttributes(debugStream, 6, element1);
			dumpElementContent(debugStream, 6, element1);
		}
	}

	protected static void dumpSecondOrderSection (PrintStream debugStream, TRCNode topNode, String [] vertices)
	{
		if (debugStream != null)
			debugStream.println();
		dumpVertexElementName(debugStream, 2, topNode.getElement());		
		dumpElementAttributes(debugStream, 4, topNode.getElement());
								
		ListIterator itr = topNode.getSubNodes().listIterator();
		while (itr.hasNext()) {
			TRCNode node1 = (TRCNode)itr.next();
			TRCElement element1 = node1.getElement();
			
			boolean match = false;
			for (int i = 0; i < vertices.length; ++i)
				if (vertices[i].equals(element1.getName()))
					match = true;
			if (match) {
				dumpVertexElementName(debugStream, 4, element1);
				dumpElementAttributes(debugStream, 6, element1);

				ListIterator itr2 = node1.getSubNodes().listIterator();
				while (itr2.hasNext()) {
					TRCNode node2 = (TRCNode)itr2.next();
					TRCElement element2 = node2.getElement();
					
					dumpElementName(debugStream, 6, element2);
					dumpElementAttributes(debugStream, 8, element2);
					dumpElementContent(debugStream, 8, element2);
				}
			}
			else {
				dumpElementName(debugStream, 4, element1);
				dumpElementAttributes(debugStream, 6, element1);
				dumpElementContent(debugStream, 6, element1);
			}			
		}
	}

}
