/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TRCRecorderInfoNodeHandler.java,v 1.4 2005/02/16 22:20:27 qiyanli Exp $
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.testgen.http;

import org.eclipse.hyades.internal.execution.testgen.TestgenException;



/**
 * @author mdunn
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 * 
 */
public class TRCRecorderInfoNodeHandler extends TRCNodeHandler implements ITRCNodeHandler
{

	private static final String	RECORDERINFO_A_TYPE
														= "type";
	private static final String	RECORDERINFO_A_TYPE_V_STOP
														= "STOP";

	private static final String	CRNL	= "\r\n";
	

	
	public void init (TRCContext context)
		throws TestgenException
	{
		super.init(context);
	}
	
	public void node (TRCNode node)
		throws TestgenException
	{

		// dispatch on type attribute
		String typeValue = getAttributeValue(RECORDERINFO_A_TYPE, node);		
		if (typeValue.equals(RECORDERINFO_A_TYPE_V_STOP)) {
			handle_stop();
			return;
		}
		else {
			// currently ignore anything but "STOP"
			return;
		}
	}
	// write all this info out from the pageList LinkedList
	private void handle_stop() throws TestgenException {
		TestGenHttp myHttp = new TestGenHttp(context);
		myHttp.handle_http_stop();
		
			
	}



}
