/**********************************************************************
 * Copyright (c) 2005 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.actions.internal;

import java.util.Iterator;
import java.util.Vector;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalExpression;
import org.eclipse.hyades.models.hierarchy.extensions.RelationalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.extensions.WhereExpression;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.impl.TracePackageImpl;
import org.eclipse.hyades.trace.ui.filters.IFilterAttribute;
import org.eclipse.hyades.trace.ui.filters.internal.dialogs.FiltersAdvancedUI;
import org.eclipse.hyades.trace.ui.internal.filters.BasicFeatureFilterAttribute;
import org.eclipse.hyades.trace.ui.internal.filters.FilterTraceViewer;
import org.eclipse.hyades.trace.views.adapter.internal.MemoryStatisticViewer;
import org.eclipse.hyades.trace.views.adapter.internal.ProfilingAdvancedTabAttributeSet;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class FilterOutAction  implements IObjectActionDelegate {

	private EObject filterOutObjs[];	
	private FilterTraceViewer viewer;
	//private static RelationalOperators FILTER_OUT_OPERATOR = RelationalOperators.get(RelationalOperators.NEQ);
	private static String FILTER_OUT_OPERATOR = BasicFeatureFilterAttribute.getOperatorString(RelationalOperators.get(RelationalOperators.NEQ));	
	
	/* (non-Javadoc)
	 * @see org.eclipse.ui.IObjectActionDelegate#setActivePart(org.eclipse.jface.action.IAction, org.eclipse.ui.IWorkbenchPart)
	 */
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
		if (targetPart instanceof FilterTraceViewer)
			viewer = (FilterTraceViewer) targetPart;
		else
			viewer = null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 */
	public void run(IAction action) {
		if (viewer == null)
			return;
		
		ProfilingAdvancedTabAttributeSet advancedSet = new ProfilingAdvancedTabAttributeSet();
		
		SimpleSearchQuery query = viewer.advancedQuery();
		EList arguments;
		LogicalExpression logicalExpression;	
		int openIndex = -1;
		
		if (query.getWhereExpression() != null 
				&& (query.getWhereExpression() instanceof LogicalExpression))
		{
			logicalExpression = (LogicalExpression)query.getWhereExpression();
			arguments = logicalExpression.getArguments();
		}
		else
		{
			return;
		}		
		
		openIndex = openIndex + arguments.size();
		
		for (int i = 0; i < filterOutObjs.length; i++)
		{
			EAttribute attribute = null;
			String value = null;
			if (filterOutObjs[i] instanceof TRCPackage)
			{
				attribute = TracePackageImpl.init().getTRCPackage_Name();
				value = ((TRCPackage)filterOutObjs[i]).getName();
			}
			else if (filterOutObjs[i] instanceof TRCClass)
			{
				attribute = TracePackageImpl.init().getTRCClass_Name();
				value = ((TRCClass)filterOutObjs[i]).getName();
			}
			else if ((filterOutObjs[i] instanceof TRCMethod) && !(viewer instanceof MemoryStatisticViewer))
			{
				attribute = TracePackageImpl.init().getTRCMethod_Name();
				value = ((TRCMethod)filterOutObjs[i]).getName();
			}

			if (attribute != null && value != null)
			{
				IFilterAttribute filterAttribute = advancedSet.getFilterAttribute(attribute);
				
				if (filterAttribute != null)
				{
					WhereExpression whereExpression = filterAttribute.getWhereExpression(FILTER_OUT_OPERATOR, value);
					whereExpression.setName(FiltersAdvancedUI.getWhereExpressionName(logicalExpression, filterAttribute));
					arguments.add(whereExpression);
				}
					
			}
			openIndex++;
		}
		
		viewer.updateAdvancedQuery(query, openIndex);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction, org.eclipse.jface.viewers.ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {

		if (selection != null && selection instanceof IStructuredSelection)
		{
			Vector filterOutObjsV = new Vector();
			
			Iterator iter = ((IStructuredSelection)selection).iterator();
		
			while (iter.hasNext())
			{
				Object obj = iter.next();
				
				if (obj instanceof TRCPackage || obj instanceof TRCClass || obj instanceof TRCMethod)
					filterOutObjsV.addElement(obj);
			}
			
			
			filterOutObjs = new EObject[filterOutObjsV.size()];
			
			for (int i = 0; i < filterOutObjs.length; i++)
			{
				filterOutObjs[i] = (EObject)filterOutObjsV.elementAt(i);
			}
		}
		else
		{
			filterOutObjs = new EObject[0];
		}		
	}

}
