/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: OpenSourceAction.java,v 1.6 2005/03/23 21:05:47 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.actions.internal;

import org.eclipse.hyades.trace.views.util.internal.OpenSource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

/**
 * Insert the type's description here.
 * Creation date: (09/28/2000 12:00:37 PM)
 * @author: Administrator
 */
public class OpenSourceAction extends OpenTraceViewAction
{
	protected ISelection selection;
	
/**
 * OpenReferencePatternView constructor comment.
 * @param label java.lang.String
 */
public OpenSourceAction() {
	super("");
}
/**
 * OpenReferencePatternView constructor comment.
 * @param label java.lang.String
 */
public OpenSourceAction(String label) {
	super(label);
}
/**
 * OpenReferencePatternView constructor comment.
 * @param label java.lang.String
 * @param image com.ibm.jface.parts.IImage
 */
public OpenSourceAction(String label, ImageDescriptor image) {
	super(label, image);
}

/**
 * 
 */   
public void run()
{
	Object sel = null;
	
	if(selection != null && !selection.isEmpty())
	{
		sel = ((IStructuredSelection)selection).getFirstElement();
	}
	
	OpenSource.openSource(sel);
	
	sel = null;
	  
}

public void selectionChanged(IAction action, ISelection selection) {
	
	this.selection = selection;
}

/*
 * 
 */
public void run(IAction action)
{
	run();
}

public void dispose()
{
	super.dispose();
	
	selection = null;
	
}

}
