/**********************************************************************
 * Copyright (c) 2005 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.adapter.internal;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsFactory;
import org.eclipse.hyades.models.hierarchy.extensions.OrderByElement;
import org.eclipse.hyades.models.hierarchy.extensions.OrderByOperators;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleOperand;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.trace.impl.TracePackageImpl;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.filters.FiltersStandardTabUI;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class FilterEventsUI {
	//public static EAttribute ATTRIBUTE_CREATION_TIME = CBEPackageImpl.init().getCBECommonBaseEvent_CreationTime();
	//public static EClass ATTRIBUTE_EVENTS = CBEPackageImpl.init().getCBECommonBaseEvent();	
	private static EAttribute[] comboAttributes =
	{
		TracePackageImpl.init().getTRCPackage_BaseTime(),
		TracePackageImpl.init().getTRCPackage_CumulativeTime(),
		TracePackageImpl.init().getTRCPackage_Calls(),
		TracePackageImpl.init().getTRCPackage_TotalSize(),
		TracePackageImpl.init().getTRCPackage_CollectedSize(),
		TracePackageImpl.init().getTRCPackage_TotalInstances(),
		TracePackageImpl.init().getTRCPackage_CollectedInstances()		
	};
	
	
	private Button filterByTimeOrEventsControl;
	
	private Combo orderCombo;
	private Text lengthText;
	private Combo typeOfDurationCombo;
	
	private FiltersStandardTabUI _standardTabUI;

	public FilterEventsUI(FiltersStandardTabUI standardTabUI)
	{
		_standardTabUI = standardTabUI;
	}
	
	public Control createControl(Composite parent) {
		Composite timeEventsContainer = createCompositeWithNumberColumns(parent, 1);
		
		filterByTimeOrEventsControl = new Button(timeEventsContainer, SWT.CHECK);
		//_caseControl.setLayoutData(GridUtil.createHorizontalFill());
		filterByTimeOrEventsControl.setLayoutData(new GridData());
		filterByTimeOrEventsControl.setText(TraceUIPlugin.getString("STR_FILTER_BY_TIME_EVENTS_LABEL"));
		filterByTimeOrEventsControl.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				//getFilter().putAttributeOperatorValue(FILTER_STANDARD_TIME_OR_EVENTS, "=", String.valueOf(filterByTimeOrEventsControl.getSelection()));
				filterByTimeEventsUpdate();
			}
		});

		Composite comboBoxContainers = createCompositeWithNumberColumns(timeEventsContainer, 5);
		
		Label showLabel = new Label(comboBoxContainers, SWT.BOLD);
		showLabel.setText(TraceUIPlugin.getString("STR_FILTER_BY_SHOW"));
		
		orderCombo = new Combo(comboBoxContainers, SWT.BORDER | SWT.READ_ONLY);
		orderCombo.setLayoutData(GridUtil.createHorizontalFill());
		orderCombo.add(TraceUIPlugin.getString("STR_FILTER_BY_COMBO_ORDER2"));
		orderCombo.add(TraceUIPlugin.getString("STR_FILTER_BY_COMBO_ORDER1"));
		orderCombo.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				//getFilter().putAttributeOperatorValue(FILTER_STANDARD_ORDER, "=", orderCombo.getText());
			}
		});
		
		lengthText = new Text(comboBoxContainers, SWT.BORDER);
		lengthText.setLayoutData(GridUtil.createHorizontalFill());
		lengthText.addKeyListener(new KeyAdapter() {
			public void keyReleased(KeyEvent key) {
				if (!isInt(lengthText.getText().trim()))
					_standardTabUI.setError(TraceUIPlugin.getString("STR_FILTER_NOT_VALID_INTEGER"));
				else
					_standardTabUI.noError();
			}
		});
		
		Label byLabel = new Label(comboBoxContainers, SWT.BOLD);
		byLabel.setText(TraceUIPlugin.getString("STR_FILTER_BY_TYPES"));
		
		typeOfDurationCombo = new Combo(comboBoxContainers, SWT.BORDER | SWT.READ_ONLY);
		typeOfDurationCombo.setLayoutData(GridUtil.createHorizontalFill());
		typeOfDurationCombo.add(TraceUIPlugin.getString("STR_FILTER_BY_COMBO_1BASE_TIME"));
		typeOfDurationCombo.add(TraceUIPlugin.getString("STR_FILTER_BY_COMBO_2CUMULATIVE_TIME"));
		typeOfDurationCombo.add(TraceUIPlugin.getString("STR_FILTER_BY_COMBO_3CALLS"));
		typeOfDurationCombo.add(TraceUIPlugin.getString("STR_FILTER_BY_COMBO_4TOTAL_SIZE"));
		typeOfDurationCombo.add(TraceUIPlugin.getString("STR_FILTER_BY_COMBO_5COLLECTED_SIZE"));
		typeOfDurationCombo.add(TraceUIPlugin.getString("STR_FILTER_BY_COMBO_6TOTAL_INSTANCES"));
		typeOfDurationCombo.add(TraceUIPlugin.getString("STR_FILTER_BY_COMBO_7COLLECTED_INSTANCES"));		
		//typeOfDurationCombo.add(TraceUIPlugin.getString("STR_FILTER_BY_COMBO_TYPE2"));
		typeOfDurationCombo.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				//getFilter().putAttributeOperatorValue(FILTER_STANDARD_TYPE, "=", typeOfDurationCombo.getText());
			}
		});
		
		orderCombo.select(0);
		typeOfDurationCombo.select(0);		
		
		return timeEventsContainer;
	}	
	
	private Composite createCompositeWithNumberColumns(Composite parent, int numColumns)
	{
		Composite container = new Composite(parent, SWT.NULL);
		container.setLayoutData(GridUtil.createHorizontalFill());
		GridLayout layout = new GridLayout();
		layout.numColumns = numColumns;
		container.setLayout(layout);
		
		return container;
	}
	
	public void filterByTimeEventsUpdate()
	{
		boolean filterByTimeOrEvents = filterByTimeOrEventsControl.getSelection(); 
		orderCombo.setEnabled(filterByTimeOrEvents);
		lengthText.setEnabled(filterByTimeOrEvents);
		typeOfDurationCombo.setEnabled(filterByTimeOrEvents);		
	}		
	
	
//	private Double convertFromSeconds(Double seconds)
//	{
//		return seconds;
//	}
//
//	private Double convertToSeconds(Double time)
//	{
//		return time;
//	}	
	
	private int getInt(String str)
	{
		return Integer.parseInt(str);
	}
	
	private boolean isInt(String str)
	{
		try
		{
			Integer.parseInt(str);
			return true;
		}
		catch (NumberFormatException nfe)
		{
			return false;
		}
	}	
	
	public void initializeValues()
	{
		filterByTimeOrEventsControl.setSelection(false);		
	}
	
	public void initializeFrom(SimpleSearchQuery filter)
	{
		if (filter.getOrderByExpresions().size() > 0)
		{
			filterByTimeOrEventsControl.setSelection(true);
			
			OrderByElement orderByElement = (OrderByElement)filter.getOrderByExpresions().get(0);
			
			if (OrderByOperators.ASC_LITERAL.equals(orderByElement.getOperator()))
				orderCombo.select(1);
			else
				orderCombo.select(0);

			lengthText.setText((new Integer(filter.getMaxElements())).toString());
			
			EStructuralFeature feature = ((SimpleOperand)orderByElement.getOperand()).getFeature();
			for (int i = 0; i < comboAttributes.length; i++)
			{
				if (comboAttributes[i].equals(feature))
				{
					typeOfDurationCombo.select(i);
					break;
				}
			}
				
		}
		else
		{
			filterByTimeOrEventsControl.setSelection(false);	
			orderCombo.select(0);	
			lengthText.setText("10");	
			typeOfDurationCombo.select(0);
		}
		
		filterByTimeEventsUpdate();
	}	
	
	
	public void performApply(SimpleSearchQuery filter)
	{
		if (filterByTimeOrEventsControl.getSelection())
		{
			EStructuralFeature feature = comboAttributes[typeOfDurationCombo.getSelectionIndex()];
			
			OrderByOperators operator; 
			if (orderCombo.getSelectionIndex() == 1)
				operator = OrderByOperators.ASC_LITERAL;
			else
				operator = OrderByOperators.DESC_LITERAL;

			int maxElements = getInt(lengthText.getText().trim());
			
			addOrderByExpressionAndSetMaxElements(filter, feature, operator, maxElements);
		}
	}	
	
	public static void addOrderByExpressionAndSetMaxElements(SimpleSearchQuery query, EStructuralFeature feature, OrderByOperators operator, int maxElements)
	{
		OrderByElement orderByElement = ExtensionsFactory.eINSTANCE.createOrderByElement();
		SimpleOperand operand = ExtensionsFactory.eINSTANCE.createSimpleOperand();
		operand.setFeature(feature);
		orderByElement.setOperand(operand);
		orderByElement.setOperator(operator);
		query.getOrderByExpresions().add(orderByElement);
		query.setMaxElements(maxElements);
	}
}
