/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ImportTraceRange.java,v 1.1 2005/03/07 16:58:50 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.views.adapter.internal;

import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.filters.FiltersStandardTabUI;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

/**
 *  Page 2 of the base resource import-from-zip Wizard.
 *  which specific the range of file to be imported.
 */

public class ImportTraceRange implements SelectionListener,ModifyListener {

	private Label _regionLabel;
	private Button _wholeFileBtn;
	private Button _inRangeBtn;
	private Label _startLabel;
	private Text _startText;
	private Label _ofFileLabel1;		
	private Label _ofFileLabel2;
	private Label _stopLabel;
	private Text _stopText;
	private double startValue	= 0.0;
	private double stopValue	= 100.0;
	private FiltersStandardTabUI _tabUI;

public ImportTraceRange(FiltersStandardTabUI tabUI) {
	_tabUI = tabUI;	
}

public void createControl(Composite parent) {
	GridLayout layout;
	
	Group composite = new Group(parent, SWT.NULL);
	composite.setLayout(new GridLayout());
	composite.setLayoutData(new GridData(
		GridData.VERTICAL_ALIGN_FILL | GridData.HORIZONTAL_ALIGN_FILL));
	composite.setSize(composite.computeSize(SWT.DEFAULT, SWT.DEFAULT));
	composite.setText(TraceUIPlugin.getString("FILTER_RANGE_OPTION_STR"));

	Composite optionGroup = new Composite(composite, SWT.NONE);
	layout = new GridLayout();
	layout.numColumns = 7;
	layout.verticalSpacing=5;
	optionGroup.setLayout(layout);
	GridData gd = GridUtil.createFill();
	optionGroup.setLayoutData(gd);
	
	_wholeFileBtn = new Button(optionGroup, SWT.RADIO);
	gd = new GridData();
	gd.horizontalSpan = 7;
	_wholeFileBtn.setLayoutData(gd);
	_wholeFileBtn.setText(TraceUIPlugin.getString("FILTER_RANGE_COMPLETE_STR"));
	
	_inRangeBtn = new Button(optionGroup, SWT.RADIO);
	_inRangeBtn.setText(TraceUIPlugin.getString("FILTER_RANGE_PARTIAL_STR"));
	
	_startLabel = new Label(optionGroup, SWT.NONE);
	_startLabel.setText(TraceUIPlugin.getString("FILTER_RANGE_FROM_STR"));
	
	_startText = new Text(optionGroup, SWT.BORDER);
	gd = new GridData();
	gd.widthHint = 30;
	_startText.setLayoutData(gd);
	
	_ofFileLabel1 = new Label(optionGroup, SWT.NONE);
	_ofFileLabel1.setText(TraceUIPlugin.getString("FILTER_RANGE_PERCENT_STR"));
	
	_stopLabel = new Label(optionGroup, SWT.NONE);
	_stopLabel.setText(TraceUIPlugin.getString("FILTER_RANGE_TO_STR"));

	_stopText = new Text(optionGroup, SWT.BORDER);
	gd = new GridData();
	gd.widthHint = 30;
	_stopText.setLayoutData(gd);	
	
	_ofFileLabel2 = new Label(optionGroup, SWT.NONE);
	_ofFileLabel2.setText(TraceUIPlugin.getString("FILTER_RANGE_PERCENT_STR"));	

	_wholeFileBtn.addSelectionListener(this);
	_inRangeBtn.addSelectionListener(this);
	_startText.addModifyListener(this);
	_stopText.addModifyListener(this);

	initData();
}

private void initData()
{
	_wholeFileBtn.setSelection(true);
	_startText.setText(String.valueOf(startValue));
	_stopText.setText(String.valueOf(stopValue));
	setRangeInputEnable(false);	
}

public Button getWholeFileBtn()
{
	return _wholeFileBtn;
}
public Button getInRangeBtn()
{
	return _inRangeBtn;
}
public boolean getWholeFileSelection()
{
	return _wholeFileBtn.getSelection();
}
public boolean getInRangeSelection()
{
	return _inRangeBtn.getSelection();
}
public double getStartRange()
{
	return startValue;
}
public double getStopRange()
{
	return stopValue;
}
public String checkRegionValue()
{
	if (_startText.getText().trim().equals("") || _stopText.getText().trim().equals(""))
			return TraceUIPlugin.getString("FILTER_RANGE_CANNOT_EMPTY_VALUE");
		else
		{
			try 
			{
				startValue = Double.parseDouble(_startText.getText().trim());
				stopValue = Double.parseDouble(_stopText.getText().trim());
				if (startValue > stopValue)
					return TraceUIPlugin.getString("FILTER_RANGE_START_LARGER_STOP");
				else if (startValue == stopValue)
					return TraceUIPlugin.getString("FILTER_RANGE_CANNOT_SAME");
				else if (startValue <0 || startValue >100 || stopValue<0 || stopValue >100)
					return TraceUIPlugin.getString("FILTER_RANGE_INVALID_IMPORT_RANGE");
				else 
				{
					return null;
				}
			}
			catch (NumberFormatException nfe)
			{
				return TraceUIPlugin.getString("FILTER_RANGE_INVALID_IMPORT_RANGE");
			}
		}
}

public void modifyText(ModifyEvent e)
{
	if (e.widget == _startText || e.widget == _stopText)
		_tabUI.setError(checkRegionValue());
}


public void setRangeInputEnable(boolean enable)
{

	_startLabel.setEnabled(enable);
	_startText.setEnabled(enable);
	_ofFileLabel1.setEnabled(enable);
	_stopLabel.setEnabled(enable);
	_stopText.setEnabled(enable);
	_ofFileLabel2.setEnabled(enable);
}

public void widgetSelected(SelectionEvent e)
{
	if (e.widget == _wholeFileBtn)
	{
		setRangeInputEnable(false);
		startValue =0;
		stopValue = 100;
		_tabUI.noError();
		
	}
	else if (e.widget == _inRangeBtn)
	{
		setRangeInputEnable(true);
		_tabUI.setError(checkRegionValue());
		
	}
}

public void widgetDefaultSelected(SelectionEvent e) {}

}
