/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.adapter.internal;

import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;
import org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression;
import org.eclipse.hyades.models.hierarchy.extensions.RelationalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.WhereExpression;
import org.eclipse.hyades.models.trace.TracePackage;
import org.eclipse.hyades.trace.ui.filters.IAdvancedTabAttributeSet;
import org.eclipse.hyades.trace.ui.filters.IFilterAttribute;
import org.eclipse.hyades.trace.ui.internal.filters.BasicFeatureFilterAttribute;
import org.eclipse.hyades.trace.ui.internal.filters.ModelUtils;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;


public class ProfilingAdvancedTabAttributeSet implements IAdvancedTabAttributeSet
{
	public class ObjectCollectedFilterAttribute implements IFilterAttribute
	{
		private String _id;
		private String _displayText;
		
		public ObjectCollectedFilterAttribute(String id, String displayText)
		{
			_id = id;
			_displayText = displayText;
		}

		
		public String id() {
			return _id;
		}

		public String displayText() {
			return _displayText;
		}

		public String validate(String operator, String value) {
			if (!TraceUIPlugin.getString("STR_ST_FILTER_OBJECT_COLLECTED_TRUE").equalsIgnoreCase(value)
				&& !TraceUIPlugin.getString("STR_ST_FILTER_OBJECT_COLLECTED_FALSE").equalsIgnoreCase(value))
				return TraceUIPlugin.getString("STR_ST_FILTER_OBJECT_COLLECTED_ERROR");

			return null;
		}

		public String[] operators() {
			String[] operators = new String[1];
			
			operators[0] = TraceUIPlugin.getString("STR_ST_FILTER_OBJECT_COLLECTED_EQ");
			return operators;
		}

		public WhereExpression getWhereExpression(String operator, String value) {
			if (TraceUIPlugin.getString("STR_ST_FILTER_OBJECT_COLLECTED_TRUE").equalsIgnoreCase(value))
				return ModelUtils.createBinaryExpression(TracePackage.eINSTANCE.getTRCFullTraceObject_CollectTime(), RelationalOperators.get(RelationalOperators.GT), "0", false);
		    else
		    	return ModelUtils.createBinaryExpression(TracePackage.eINSTANCE.getTRCFullTraceObject_CollectTime(), RelationalOperators.get(RelationalOperators.EQ), "0", false);
		}

		public String getValue(WhereExpression whereExpression) {
		 	BinaryExpression be = (BinaryExpression)whereExpression;
		 	
		 	if (RelationalOperators.get(RelationalOperators.GT).equals(be.getOperator()))
		 		return TraceUIPlugin.getString("STR_ST_FILTER_OBJECT_COLLECTED_TRUE");
		 	else
		 		return TraceUIPlugin.getString("STR_ST_FILTER_OBJECT_COLLECTED_FALSE");	
		}

		public String getOperator(WhereExpression whereExpression) {
			return TraceUIPlugin.getString("STR_ST_FILTER_OBJECT_COLLECTED_EQ");
		}

		public String defaultValue() {
			return TraceUIPlugin.getString("STR_ST_FILTER_OBJECT_COLLECTED_TRUE");
		}
	}
	
	
	private static RelationalOperators[] _operators = new RelationalOperators[]
	   {
			RelationalOperators.get(RelationalOperators.EQ),
			RelationalOperators.get(RelationalOperators.LIKE),
			RelationalOperators.get(RelationalOperators.NEQ),
			RelationalOperators.get(RelationalOperators.GT),
			RelationalOperators.get(RelationalOperators.LT),
			RelationalOperators.get(RelationalOperators.GE),
			RelationalOperators.get(RelationalOperators.LE)
	   };
	
	
	private IFilterAttribute [] _attributes = new IFilterAttribute[]
		{
			new BasicFeatureFilterAttribute("ftprofiling_ad1", TraceUIPlugin.getString("STR_ST_FILTER_PACKAGE_NAME"), TracePackage.eINSTANCE.getTRCPackage_Name(), _operators, true),
		    new BasicFeatureFilterAttribute("ftprofiling_ad2", TraceUIPlugin.getString("STR_ST_PACKAGE_CPU_TIME"), TracePackage.eINSTANCE.getTRCPackage_BaseTime(), _operators, true), 
		    new BasicFeatureFilterAttribute("ftprofiling_ad3", TraceUIPlugin.getString("STR_ST_PACKAGE_CPU_INHTIME"), TracePackage.eINSTANCE.getTRCPackage_InheritedBaseTime(), _operators, true),
		    new BasicFeatureFilterAttribute("ftprofiling_ad4", TraceUIPlugin.getString("STR_ST_PACKAGE_STACK_TIME"), TracePackage.eINSTANCE.getTRCPackage_CumulativeTime(), _operators, true),
		    new BasicFeatureFilterAttribute("ftprofiling_ad5", TraceUIPlugin.getString("STR_ST_PACKAGE_STACK_INHTIME"), TracePackage.eINSTANCE.getTRCPackage_InheritedCumulativeTime(), _operators, true),
		    new BasicFeatureFilterAttribute("ftprofiling_ad6", TraceUIPlugin.getString("STR_ST_PACKAGE_CALLS"), TracePackage.eINSTANCE.getTRCPackage_Calls(), _operators, true),
		    new BasicFeatureFilterAttribute("ftprofiling_ad7", TraceUIPlugin.getString("STR_ST_PACKAGE_INHCALLS"), TracePackage.eINSTANCE.getTRCPackage_InheritedCalls(), _operators, true),
			new BasicFeatureFilterAttribute("ftprofiling_ad8", TraceUIPlugin.getString("STR_ST_PACKAGE_INSTANCES"), TracePackage.eINSTANCE.getTRCPackage_TotalInstances(), _operators, true), 
			new BasicFeatureFilterAttribute("ftprofiling_ad9", TraceUIPlugin.getString("STR_ST_PACKAGE_COLLECTED"), TracePackage.eINSTANCE.getTRCPackage_CollectedInstances(), _operators, true),			
			new BasicFeatureFilterAttribute("ftprofiling_ad10", TraceUIPlugin.getString("STR_ST_PACKAGE_SIZE"), TracePackage.eINSTANCE.getTRCPackage_TotalSize(), _operators, true),
			
			new BasicFeatureFilterAttribute("ftprofiling_ad11", TraceUIPlugin.getString("STR_ST_FILTER_CLASS_NAME"), TracePackage.eINSTANCE.getTRCClass_Name(), _operators, true),
		    new BasicFeatureFilterAttribute("ftprofiling_ad12", TraceUIPlugin.getString("STR_ST_CLASS_CPU_TIME"), TracePackage.eINSTANCE.getTRCClass_BaseTime(), _operators, true), 
		    new BasicFeatureFilterAttribute("ftprofiling_ad13", TraceUIPlugin.getString("STR_ST_CLASS_CPU_INHTIME"), TracePackage.eINSTANCE.getTRCClass_InheritedBaseTime(), _operators, true),
		    new BasicFeatureFilterAttribute("ftprofiling_ad14", TraceUIPlugin.getString("STR_ST_CLASS_STACK_TIME"), TracePackage.eINSTANCE.getTRCClass_CumulativeTime(), _operators, true),
		    new BasicFeatureFilterAttribute("ftprofiling_ad15", TraceUIPlugin.getString("STR_ST_CLASS_STACK_INHTIME"), TracePackage.eINSTANCE.getTRCClass_InheritedCumulativeTime(), _operators, true),
		    new BasicFeatureFilterAttribute("ftprofiling_ad16", TraceUIPlugin.getString("STR_ST_CLASS_CALLS"), TracePackage.eINSTANCE.getTRCClass_Calls(), _operators, true),
		    new BasicFeatureFilterAttribute("ftprofiling_ad17", TraceUIPlugin.getString("STR_ST_CLASS_INHCALLS"), TracePackage.eINSTANCE.getTRCClass_InheritedCalls(), _operators, true),
			new BasicFeatureFilterAttribute("ftprofiling_ad18", TraceUIPlugin.getString("STR_ST_CLASS_INSTANCES"), TracePackage.eINSTANCE.getTRCClass_TotalInstances(), _operators, true), 
			new BasicFeatureFilterAttribute("ftprofiling_ad19", TraceUIPlugin.getString("STR_ST_CLASS_COLLECTED"), TracePackage.eINSTANCE.getTRCPackage_CollectedInstances(), _operators, true),			
			new BasicFeatureFilterAttribute("ftprofiling_ad20", TraceUIPlugin.getString("STR_ST_CLASS_SIZE"), TracePackage.eINSTANCE.getTRCClass_TotalSize(), _operators, true),	
			
			new BasicFeatureFilterAttribute("ftprofiling_ad21", TraceUIPlugin.getString("STR_ST_FILTER_METHOD_NAME"), TracePackage.eINSTANCE.getTRCMethod_Name(), _operators, true),
		    new BasicFeatureFilterAttribute("ftprofiling_ad22", TraceUIPlugin.getString("STR_ST_METHOD_CPU_TIME"), TracePackage.eINSTANCE.getTRCMethod_BaseTime(), _operators, true), 
		    new BasicFeatureFilterAttribute("ftprofiling_ad23", TraceUIPlugin.getString("STR_ST_METHOD_STACK_TIME"), TracePackage.eINSTANCE.getTRCMethod_CumulativeTime(), _operators, true),
		    new BasicFeatureFilterAttribute("ftprofiling_ad24", TraceUIPlugin.getString("STR_ST_METHOD_CALLS"), TracePackage.eINSTANCE.getTRCMethod_Calls(), _operators, true),
			
		    //new BasicFeatureFilterAttribute("ftprofiling_ad25", TraceUIPlugin.getString("STR_ST_FILTER_PROCESS_PID"), TracePackage.eINSTANCE.getTRCProcess_Pid(), _operators, true),
			//new BasicFeatureFilterAttribute("ftprofiling_ad26", TraceUIPlugin.getString("STR_ST_FILTER_PROCESS_NAME"), TracePackage.eINSTANCE.getTRCProcess_Name(), _operators, true),
			
		    new BasicFeatureFilterAttribute("ftprofiling_ad27", TraceUIPlugin.getString("STR_ST_FILTER_THREAD_ID"), TracePackage.eINSTANCE.getTRCThread_Id(), _operators, true),
			new BasicFeatureFilterAttribute("ftprofiling_ad28", TraceUIPlugin.getString("STR_ST_FILTER_THREAD_NAME"), TracePackage.eINSTANCE.getTRCThread_Name(), _operators, true),
			
			new BasicFeatureFilterAttribute("ftprofiling_ad29", TraceUIPlugin.getString("STR_ST_FILTER_OBJECT_ID"), TracePackage.eINSTANCE.getTRCObject_Id(), _operators, true),
			new BasicFeatureFilterAttribute("ftprofiling_ad30", TraceUIPlugin.getString("STR_ST_FILTER_OBJECT_SIZE"), TracePackage.eINSTANCE.getTRCObject_Size(), _operators, true),
			
			new BasicFeatureFilterAttribute("ftprofiling_ad31", TraceUIPlugin.getString("STR_ST_FILTER_OBJECT_CALLS"), TracePackage.eINSTANCE.getTRCFullTraceObject_Calls(), _operators, true),		
			new BasicFeatureFilterAttribute("ftprofiling_ad32", TraceUIPlugin.getString("STR_ST_FILTER_OBJECT_BASE_TIME"), TracePackage.eINSTANCE.getTRCFullTraceObject_BaseTime(), _operators, true),
			new BasicFeatureFilterAttribute("ftprofiling_ad33", TraceUIPlugin.getString("STR_ST_FILTER_OBJECT_CUMULATIVE_TIME"), TracePackage.eINSTANCE.getTRCFullTraceObject_CumulativeTime(), _operators, true),
			new ObjectCollectedFilterAttribute("ftprofiling_ad34", TraceUIPlugin.getString("STR_ST_FILTER_OBJECT_COLLECTED")),	
			
			new BasicFeatureFilterAttribute("ftprofiling_ad35", TraceUIPlugin.getString("STR_ST_FILTER_AGENT_NAME"), HierarchyPackage.eINSTANCE.getTRCAgent_Name(), _operators, true)
		    //new BasicFeatureFilterAttribute("ftprofiling_ad36", TraceUIPlugin.getString("STR_ST_FILTER_HOST_NAME"), HierarchyPackage.eINSTANCE.getTRCNode_Name(), _operators, true),		
		};
	
	
	public IFilterAttribute getFilterAttribute(EStructuralFeature feature)
	{
		for (int i = 0; i < _attributes.length; i++)
		{
			if (((BasicFeatureFilterAttribute)_attributes[i]).feature().equals(feature))
				return _attributes[i];
		}
		
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.filters.ui.ext.IAdvancedAttributeSet#getAttributes()
	 */
	public IFilterAttribute[] getAttributes() {
		return _attributes;
	}
}

	
