/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ColorScheme.java,v 1.4 2005/02/16 22:24:04 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.internal;

import org.eclipse.swt.graphics.Color;

// A ColorScheme is a set of colors designed either to show
// quantitative data or a set of diverse values (typically for
// categorical data, though it may be used for quantitative data as well).
// In either case the number of buckets will be scaled to span the number
// of colors in the color scheme.
//
// There are two representations of ColorScheme.  Usage is identical in either.
//           DiscreteColorScheme   - a list of colors
//           ContinuousColorScheme - describes a color space in terms of
//                                   control points along the H, S, V axes
//
public abstract class ColorScheme
{

	// --- Internal representation ---
	protected String _description; // Optional comment about the scheme
	protected Color  _unknown; // Extra color for mapping N/A or outlying data

	public ColorScheme () {
	}
	
	// Add a color
	public void add(Color c) {
		System.err.println("Function not available for this type of color scheme");
		}
	// --- Using a color scheme ---
	public abstract Color color(int bucket, int numBuckets);
	
	public String description() {
		return _description;
	}
		public void setDescription(String description) {
		_description = description;
	}
	public void setUnknown (Color c) {
		_unknown = c;
	}
	public Color unknown() {
		return _unknown;
	}
}
