/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TracePluginImages.java,v 1.12 2005/02/24 14:54:25 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.internal;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class TracePluginImages
{
  private static URL fgIconBaseURL= null;

	static {
		try {
			fgIconBaseURL= new URL(TraceUIPlugin.getDefault().getBundle().getEntry("/"), "icons/full/" ); //$NON-NLS-1$ //$NON-NLS-2$
		} catch (MalformedURLException e) {
			TraceUIPlugin.getDefault().log(e);
		}
	}	
  	
	/*
	 * Set of predefined Image Descriptors.
	 * there following String are all $NON-NLS-1$
	 */
	public static final String T_LCL		= "lcl16"; //$NON-NLS-1$
	public static final String T_TOOL	= "tool16"; //$NON-NLS-1$
	public static final String T_VIEW	= "view16"; //$NON-NLS-1$
	public static final String T_OBJ		= "obj16"; //$NON-NLS-1$
	public static final String T_WIZBAN	= "wizban"; //$NON-NLS-1$

  public static Hashtable _images;
  public static Hashtable _imageDescriptors;  
	
  // there following String are all $NON-NLS-1$
  public static final String IMG_SOURCE 		= "opensource_co.gif";//"source.gif";  
  public static final String IMG_CLASS_ST 	= "class_stat_co.gif";//"class_stat.gif";
//  public static final String IMG_EXEC 		= "execflow_view_nav.gif";//"exc.gif";
  public static final String IMG_HEAP 		= "heap_co.gif";//"heap.gif";
  public static final String IMG_METH_ST 	= "meth_stat_co.gif";//"meth_stat.gif";
  public static final String IMG_REF 		= "obj_ref_co.gif";//"ref.gif";
  public static final String IMG_METH 		= "methods_co.gif";//"methods.gif";
  public static final String IMG_OBJ 		= "objects_co.gif";//"objects.gif";
  public static final String IMG_NEXT 		= "next_nav.gif";//"next.gif";
  public static final String IMG_PREV 		= "prev_nav.gif";//"previous.gif";
  public static final String IMG_ZOOMIN 		= "zoomin_nav.gif";//"zoomin.gif";
  public static final String IMG_ZOOMOUT 	= "zoomout_nav.gif";//"zoomout.gif";
  public static final String IMG_RESTORE_ORG  = "select_zoomin.gif";
  public static final String IMG_OPEN_GRAPH_TABLE = "show_table.gif";
  public static final String IMG_HOME 		= "home_nav.gif";//"home.gif";
  public static final String IMG_CALLER 		= "showcaller_co.gif";//"caller.gif";
  public static final String IMG_CALLEE 		= "caller_co.gif";//"callee.gif";  
  public static final String IMG_METHEXEC 	= "meth_exec_co.gif";//"meth_exec.gif";
//  public static final String IMG_METHINVO 	= "meth_invc_co.gif";//"meth_invc.gif";
//  public static final String IMG_METHINVOTABLE 	= "methinvctable_view_nav.gif";//"meth_invc.gif";
  public static final String IMG_PERCENT 	= "percentage_show.gif";//"percentage_show.gif";
  public static final String IMG_DELTACOLUMNS = "delta_show.gif";//"delta_show.gif";
  public static final String IMG_DELTAUP 	= "increasedvalue_obj.gif";//"increasedvalue_obj.gif";
  public static final String IMG_DELTADOWN 	= "decreasedvalue_obj.gif";//"decreasedvalue_obj.gif";
  public static final String IMG_DELTANEW 	= "newentry_obj.gif";//"newentry_obj.gif";
  public static final String IMG_BLANK 		= "blank_obj.gif";//"blank.gif";
  public static final String IMG_COLORS 	    = "opengraphcolor_co.gif";//"zoomout.gif";
  public static final String IMG_PRINTCOLUMNS = "htmlexport_co.gif";//"htmlexport_co.gif";
  public static final String IMG_CHOOSECOLUMNS = "choosecolumn_co.gif";//"choosecolumn_co.gif"
  
  public static final String IMG_PACKAGE = "package_obj.gif";
  public static final String IMG_CLASS = "class.gif";
  public static final String IMG_PACKAGE_COL = "package_obj_col.gif";
  public static final String IMG_CLASS_COL = "class_col.gif";  
  public static final String IMG_METHOD = "methods_co.gif";
  
  public static final String IMG_EXECUTION_TYPE = "exec_statistic_view.gif";
  public static final String IMG_MEMORY_TYPE = "mem_statistic_view.gif";
  public static final String IMG_COVERAGE_TYPE = "cov_statistic_view.gif";  
  

  // there following String are all $NON-NLS-1$
  public static final ImageDescriptor DESC_IMG_ZOOMMASK   = createManaged(T_OBJ,"zoom_mask.bmp");//$NON-NLS-1$
  public static final ImageDescriptor DESC_IMG_ZOOMIN_SOURCE   = createManaged(T_OBJ,"zoomin_source.bmp");//$NON-NLS-1$
  public static final ImageDescriptor DESC_IMG_ZOOMOUT_SOURCE   = createManaged(T_OBJ,"zoomout_source.bmp");//$NON-NLS-1$
  
  public static final ImageDescriptor DESC_IMG_DELTAUP 	= createManaged(T_OBJ,IMG_DELTAUP);
  public static final ImageDescriptor DESC_IMG_DELTADOWN  = createManaged(T_OBJ,IMG_DELTADOWN);
  public static final ImageDescriptor DESC_IMG_DELTANEW 	= createManaged(T_OBJ,IMG_DELTANEW);
  public static final ImageDescriptor DESC_IMG_BLANK 	= createManaged(T_OBJ,IMG_BLANK);

  public static final ImageDescriptor DESC_IMG_CLASS	= createManaged(T_OBJ,IMG_CLASS);
  public static final ImageDescriptor DESC_IMG_PACKAGE 	= createManaged(T_OBJ,IMG_PACKAGE);
  public static final ImageDescriptor DESC_IMG_CLASS_COL = createManaged(T_OBJ,IMG_CLASS_COL);
  public static final ImageDescriptor DESC_IMG_PACKAGE_COL	= createManaged(T_OBJ,IMG_PACKAGE_COL);  
  public static final ImageDescriptor DESC_IMG_METHOD 	= createManaged(T_OBJ,IMG_METHOD);
  
  public static final ImageDescriptor DESC_IMG_EXECUTION_TYPE = createManaged(T_OBJ,IMG_EXECUTION_TYPE);
  public static final ImageDescriptor DESC_IMG_MEMORY_TYPE 	= createManaged(T_OBJ,IMG_MEMORY_TYPE);
  public static final ImageDescriptor DESC_IMG_COVERAGE_TYPE	= createManaged(T_OBJ,IMG_COVERAGE_TYPE);  

public static Image getImage(String name)
{
	return (Image)_images.get(name);
}

public static ImageDescriptor getImageDescriptor(String name)
{
	return (ImageDescriptor) _imageDescriptors.get(name);
}

private static ImageDescriptor createManaged(String prefix, String name) {
	try {
		ImageDescriptor result= ImageDescriptor.createFromURL(makeIconFileURL(prefix, name));
	
		if(_images == null || _imageDescriptors == null)
		{
			_images = new Hashtable();
			_imageDescriptors = new Hashtable();		
		}
			
		_imageDescriptors.put(name, result);
	    _images.put(name, result.createImage());
		return result;
			
	} catch (MalformedURLException e) {
		return ImageDescriptor.getMissingImageDescriptor();
	}
}

public static void setImageDescriptors(IAction action, String type, String relPath) {
	try {
		ImageDescriptor id= ImageDescriptor.createFromURL(makeIconFileURL("d" + type, relPath)); //$NON-NLS-1$
		if (id != null)
		{
			action.setDisabledImageDescriptor(id);
		}
	} catch (MalformedURLException e) {}
	
	try {
		ImageDescriptor id= ImageDescriptor.createFromURL(makeIconFileURL("c" + type, relPath)); //$NON-NLS-1$
		if (id != null)
		{	
			action.setHoverImageDescriptor(id);
		}
	} catch (MalformedURLException e) {}
	
	action.setImageDescriptor(create("e" + type, relPath)); //$NON-NLS-1$
}

private static URL makeIconFileURL(String prefix, String name) throws MalformedURLException {
	if (fgIconBaseURL == null)
		throw new MalformedURLException();

	StringBuffer buffer;
    if (prefix!=null) 
    {
		buffer= new StringBuffer(prefix);
		buffer.append('/');
		buffer.append(name);
    }
    else 
    {
    	buffer= new StringBuffer(name);
    }
	return new URL(fgIconBaseURL, buffer.toString());
}

private static ImageDescriptor create(String prefix, String name) {
	try {
		return ImageDescriptor.createFromURL(makeIconFileURL(prefix, name));
	} catch (MalformedURLException e) {
		return ImageDescriptor.getMissingImageDescriptor();
	}
}
      
public static void shutdown()
{
	if(_images == null)
	  return;
	
	for (Iterator e = _images.values().iterator(); e.hasNext();) {
		Object next = e.next();
		if (next instanceof Image && !((Image)next).isDisposed())
		{
			((Image)next).dispose();
		}
	}

	_images.clear();
	_images = null;
	_imageDescriptors.clear();
	_imageDescriptors = null;
	
}
}
