/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: GraphColorPreferencePage.java,v 1.5 2005/02/16 22:24:04 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.views.preferences.internal;

import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.util.internal.*;
import org.eclipse.jface.preference.*;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

/*
* CONTEXT_ID tcpp0000 for Console preference page
*/

/**
 * A page to set the preferences for the console
 */
public class GraphColorPreferencePage extends PreferencePage
										implements IWorkbenchPreferencePage
{
	private GraphColorUI _colorUI;
		
	/**
	 * Create the console page.
	 */
	public GraphColorPreferencePage() {
		
	}
	/**
	 * @see PreferencePage#createContents(Composite)
	 */
	protected Control createContents(Composite parent) {

		org.eclipse.ui.help.WorkbenchHelp.setHelp(
		parent,
		TraceUIPlugin.getPluginId()+".gcpp0000");
		
		_colorUI = new GraphColorUI();
		return _colorUI.createContents(parent);
								
	}
			
	/**
	 * @see IWorkbenchPreferencePage#init
	 */
	public void init(IWorkbench workbench) {
	}
	
	/**
	 * Defaults was clicked. Restore the CVS preferences to
	 * their default values
	 */
	protected void performDefaults() {
		super.performDefaults();
		
		_colorUI.performDefaults();
	}
	
	/**
	 * OK was clicked. Store the CVS preferences.
	 *
	 * @return whether it is okay to close the preference page
	 */
	public boolean performOk() {
		
		return _colorUI.performOk();
	}

	/**
	 * Returns the font data that describes the font to use for views
	 */
	public static FontData getConsoleFontData() {
		
		return GraphColorUI.getConsoleFontData();
	}
		
}
