/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: Coverage.java,v 1.6 2005/02/16 22:24:04 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.util.internal;

import java.util.ArrayList;

import org.eclipse.emf.ecore.EObject;

/*
 * @author hind.hasnaoui@fr.ibm.com  /                           
 * 
 * A data item of the table tree viewer
 * Coverage objects are associated to TRC* objects (_traceObj)
 * They store or grant access to coverage information:
 * number of methods
 * number of hit methods
 * number of method calls
 */

public abstract class Coverage {

	protected final CoverageAnalysis analysis;
	
	private ArrayList traceObjects;
	private int calls;
	private Coverage parent;

	/**
	 * @param analysis
	 * @param parent
	 */
	public Coverage(CoverageAnalysis analysis, Coverage parent) {
		this.parent = parent;
		this.analysis = analysis;
		traceObjects = new ArrayList();
	}
	
	/**
	 * @param traceObject
	 */
	public void addTraceObjects(EObject traceObject) {
		traceObjects.add(traceObject);
	}

	/**
	 * @return the array of all EObject associated to this coverage data
	 */
	public ArrayList getTraceObjects() {
		return traceObjects;
	}
	
	/**
	 * @return the first one of the EObject list associated to this coverage data
	 */
	public EObject getTraceObj() {
		return (EObject)(traceObjects != null && traceObjects.size() > 0 ? traceObjects.get(0) : null);
	}

	public abstract int getMethods();

	public abstract int getMethodsHit();

	public abstract int getMethodsMissed();

	public abstract double getPercentage();

	public abstract ArrayList getChilds();

	/**
	 * @param calls
	 */
	public void setCalls(int calls) {
		this.calls = calls;
	}

	/**
	 * @return
	 */
	public int getCalls() {
		return calls;
	}
}