/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: CoverageLeaf.java,v 1.3 2005/02/16 22:24:04 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.util.internal;

import java.util.ArrayList;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCMethod;

/*
 * 
 * @author sduguet
 *
 * A leaf data item of the table tree viewer associated to a list of TRCMethod
 * All of these EMF objects refer to the same Java source item from one or several runs
 */

public class CoverageLeaf extends Coverage {
	
	/**
	 * @param analysis
	 * @param parent
	 */
	public CoverageLeaf(CoverageAnalysis analysis, Coverage parent) {
		super(analysis, parent);
	}
	
	/**
	 * @see org.eclipse.hyades.trace.views.util.internal.Coverage#getMethods()
	 */
	public int getMethods() {
		return 1;
	}

	/**
	 * @see org.eclipse.hyades.trace.views.util.internal.Coverage#getMethodsHit()
	 */
	public int getMethodsHit() {
		return getCalls() != 0 ? 1 : 0;
	}

	/**
	 * @see org.eclipse.hyades.trace.views.util.internal.Coverage#getMethodsMissed()
	 */
	public int getMethodsMissed() {
		return getMethods() - getMethodsHit();
	}

	/**
	 * @see org.eclipse.hyades.trace.views.util.internal.Coverage#getPercentage()
	 */
	public double getPercentage() {
		return (double)getMethodsHit() / (double)getMethods();
	}

	/**
	 * @see org.eclipse.hyades.trace.views.util.internal.Coverage#getChilds()
	 */
	public ArrayList getChilds() {
		return null;
	}

	/**
	 * @param echild
	 */
	public void parse(EObject echild) {
		setCalls(getCalls()+((TRCMethod)echild).getCalls());
	}

}