/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IColumnExtension.java,v 1.3 2005/02/16 22:24:04 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.util.internal;
import org.eclipse.jface.viewers.*;
import org.eclipse.core.runtime.*;

/* What must implement a column extension plugin */
public interface IColumnExtension extends ITableLabelProvider,IExecutableExtension {
	
	/**
	 * Compares two cells of a given column
	 * @param pos column number
	 * @param e1 first cell content link
	 * @param e2 second cell content link
	 * @return the result of the comparison
	 */
	public int compare(int pos, Object e1, Object e2);

}
