package org.eclipse.hyades.logging.core;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IPreemptedLogger.java,v 1.4 2005/02/16 22:20:39 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

public interface IPreemptedLogger {
	/**
	 * Suspends the current thread until the Logging Agent is monitored or the 
	 * the parameter maximum time (milliseconds) has expired.
	 *
	 * @param maxTime the maximum amount of time (milliseconds) to suspend the current thread
	 * @return true if the logger is being monitored
	 */
	public boolean waitUntilLogging(long maxTime);


	/**
	 * Checks if the Logging Agent is logging (e.g. Agent Controller is available and the Logging Agent is being monitored).
	 *
	 * @return True if the Logging Agent is logging, otherwise false.
	 */
	public boolean isLogging();
	
	/**
	 * Deregisters this Logging Agent instance from the Agent Controller.
	 */
	public void finalize();


}