package org.eclipse.hyades.logging.core;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SerializationException.java,v 1.4 2005/04/28 14:48:14 paules Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * A typed exception for all serialization APIs in
 * <code>org.eclipse.hyades.logging.core.XmlUtility</code> that serialize a
 * Document Object Model (DOM) to an XML document.
 * </p>
 * 
 * @author Paul E. Slauenwhite
 * @version April 28, 2005
 * @since June 2, 2004
 * @see java.lang.Exception
 * @see org.eclipse.hyades.logging.core.XmlUtility
 */
public class SerializationException extends Exception {

    /**
     * Stream-Unique IDentifier (SUID) of this class.
     * <p>
     * NOTE:  This value MUST not be modified unless an incompatible 
     *        change is introduced.  
     * <p>
     * See the 'Java Object Serialization Specification' for more details.
     * <p>
     * Compatible changes include:
     * <ul>
     * <li>Adding, modifying access or modifying <code>static</code>/<code>transient</code> to non-<code>static</code>/non-<code>transient</code> of fields.</li>
     * <li>Adding or removing classes.</li>
     * <li>Adding or removing <code>writeObject</code>/<code>readObject</code> methods.</li>
     * <li>Adding <code>java.io.Serializable</code> inheritance.</li>
     * </ul>
     * <p>
     * Incompatible changes include:
     * <ul>
     * <li>Deleting, modifying non-<code>static</code>/non-<code>transient</code> to <code>static</code>/<code>transient</code> or modifying the declared type of fields.</li>
     * <li>Modifying the hierarchy or interchanging/removing <code>java.io.Serializable</code>/<code>java.io.Externalizable</code> inheritance of the class.</li>
     * <li>Modifying <code>writeObject</code>/<code>readObject</code> methods.</li>
     * <li>Adding <code>writeReplace</code>/<code>readResolve</code> methods.</li>
     * </ul>
     */
    private static final long serialVersionUID = 8218605146910106523L;

    /**
     * @see java.lang.Exception#Exception()
     */
    public SerializationException() {
        super();
    }

    /**
     * @see java.lang.Exception#Exception(java.lang.String)
     */
    public SerializationException(String message) {
        super(message);
    }
}