/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: CBELookupService.java,v 1.8 2005/02/16 22:21:02 qiyanli Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.cbe;

import java.util.Map;

import org.eclipse.hyades.loaders.util.GenericLookupService;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.models.cbe.impl.CBECommonBaseEventImpl;
/**
 * @author slavescu
 */
public class CBELookupService extends GenericLookupService {
    //~ Constructors -------------------------------------------------------------------------------

    /**
     *
     */
    public CBELookupService() {
        super();
        types.add(CBECommonBaseEvent.class);
    }

    //~ Methods ------------------------------------------------------------------------------------

    protected boolean doProcessObject(Map typeMap, Class type, Object object, boolean remove) {
        if (object == null) {
            return false;
        }

        if (type == CBECommonBaseEventImpl.class) {
            if (((CBECommonBaseEvent) object).getGlobalInstanceId() != null) {
                addOrRemove(typeMap, LoadersUtils.getLookUpKey(((CBECommonBaseEvent) object).getGlobalInstanceId()), object, remove);

                return true;
            }
        }

        return false;
    }
	protected Class getEquivalentClass(Class type) {
		if(CBECommonBaseEvent.class.isAssignableFrom(type))
			return CBECommonBaseEvent.class;
		return type;
	}

}
