/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DefaultXMLFragmentLoader.java,v 1.5 2005/02/16 22:21:02 qiyanli Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.cbe;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

import org.eclipse.hyades.loaders.hierarchy.Constants;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.XMLFragmentLoader;
import org.eclipse.hyades.models.cbe.CBEDefaultElement;
import org.eclipse.hyades.models.cbe.CBEDefaultEvent;
import org.eclipse.hyades.models.cbe.CBEFactory;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
public class DefaultXMLFragmentLoader extends Stack implements XMLFragmentLoader {
    //~ Instance fields ----------------------------------------------------------------------------

    private String agentIdRef;
	private CBEDefaultElement currentAttribute;
    private CBEDefaultElement currentChild;
    private CBEDefaultElement newCurrentChild;
    private CBEDefaultEvent rootElement;
    private HierarchyContext context;
    private Map cdataMap;
    private StringBuffer values;

    //~ Constructors -------------------------------------------------------------------------------

    /**
     *
     */
    public DefaultXMLFragmentLoader() {
        super();
        cdataMap = new HashMap();
    }

    //~ Methods ------------------------------------------------------------------------------------

    public void addAttribute(String name, String value) {
    	if(currentChild == null && name.equals(Constants.LOGGING_UTIL_AGENT_IDREF))
    	{
    		agentIdRef = value;
    	}
        currentAttribute = CBEFactory.eINSTANCE.createCBEDefaultElement();
        currentAttribute.setName(name);
        currentAttribute.getValues().add(value);

        if (currentChild != null) {
            currentChild.getChildren().add(currentAttribute);
        } else {
            rootElement.getExtendedProperties().add(currentAttribute);
        }
    }

    public void addCharacters(char[] data, int offset, int length) {
        if (currentChild == null) {
            values = (StringBuffer) cdataMap.get(rootElement);
        } else {
            values = (StringBuffer) cdataMap.get(currentChild);
        }

        if (values == null) {
            values = new StringBuffer();

            if (currentChild == null) {
                cdataMap.put(rootElement, values);
            } else {
                cdataMap.put(currentChild, values);
            }
        }

        values.append(data, offset, length);
    }

    public void addYourselfInContext() {
    	TRCAgent agent=null;
    	if(agentIdRef!=null)
    	{
    		agent = LoadersUtils.locateAgent(agentIdRef,context.getAgent());
    	}
    	if(agent==null)
    	{
			if (context.getAgent() == null) {
				LoadersUtils.createAgent(context);
				context.getAgent().setRuntimeId(agentIdRef);
				LoadersUtils.registerAgent(agentIdRef,context.getAgent());
			}
			agent=context.getAgent();
    	}

        values = (StringBuffer) cdataMap.get(rootElement);

        if (values != null) {
            String value = values.toString().trim();

            if (value.length() > 0) {
                currentAttribute = CBEFactory.eINSTANCE.createCBEDefaultElement();
                currentAttribute.setName(rootElement.getExtensionName() + "_CDATA");
                currentAttribute.getValues().add(value);
                rootElement.getExtendedProperties().add(currentAttribute);
            }

            cdataMap.remove(rootElement);
        }

        agent.getDefaultEvents().add(rootElement);
    }

    public void cleanUp() {
    	context=null;
		rootElement = null;
		values=null;
		currentChild = null;
		currentAttribute = null;
		newCurrentChild = null;
		agentIdRef=null;
		clear();
    }

    public void endChild(String name) {
        if (size() > 0) {
            values = (StringBuffer) cdataMap.get(rootElement);

            if (values != null) {
                String value = values.toString().trim();

                if (value.length() > 0) {
                    currentChild.getValues().add(value);
                }

                cdataMap.remove(currentChild);
            }

            currentChild = (CBEDefaultElement) pop();
        }
    }

    public void initialize(HierarchyContext context, String name) {
        this.context = context;
        cdataMap.clear();
        rootElement = CBEFactory.eINSTANCE.createCBEDefaultEvent();
        rootElement.setExtensionName(name);
		values=null;
        currentChild = null;
        currentAttribute = null;
        agentIdRef=null;
        clear();
    }

    public void startChild(String name) {
        push(currentChild);

        newCurrentChild = CBEFactory.eINSTANCE.createCBEDefaultElement();
        newCurrentChild.setName(name);

        if (currentChild != null) {
            currentChild.getChildren().add(newCurrentChild);
        } else {
            rootElement.getExtendedProperties().add(newCurrentChild);
        }

        currentChild = newCurrentChild;
    }
}
