/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: XMLCommonBaseEventLoader.java,v 1.18 2005/04/21 22:29:00 slavescu Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.cbe;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.models.cbe.CBEComponentIdentification;
import org.eclipse.hyades.models.cbe.CBEDefaultElement;
import org.eclipse.hyades.models.cbe.CBEExtendedDataElement;
import org.eclipse.hyades.models.cbe.CBEFactory;
import org.eclipse.hyades.models.cbe.CBEMsgDataElement;
import org.eclipse.hyades.models.cbe.CBEOtherSituation;
import org.eclipse.hyades.models.cbe.CBEPackage;
import org.eclipse.hyades.models.cbe.CBESituation;
import org.eclipse.hyades.models.cbe.impl.CBECommonBaseEventImpl;
import org.eclipse.hyades.models.hierarchy.CorrelationContainer;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.models.hierarchy.CorrelationEngine;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;


/**
 * @author slavescu
 *
 */
public class XMLCommonBaseEventLoader extends CBEBaseXMLFragmentLoader {
    //~ Instance fields ----------------------------------------------------------------------------

    // ----------------------------------------------------------------------------
    private CBECommonBaseEvent rootElement;
    private CorrelationContainer correlationContainer = HierarchyFactory.eINSTANCE.createCorrelationContainer();
    private CorrelationEngine correlationEngine = HierarchyFactory.eINSTANCE.createCorrelationEngine();
    private CBESituation situation;
    private EAttribute cAtt;
    private EObject currentChild;
    private EObject tempObject;
    private Map cdataMap;
    private String associationEngineID;
    private String resolvedEvents;
    private StringBuffer values;
	private boolean collectXML;
	private XMLCollector xmlCollector=new XMLCollector();

    //~ Constructors -------------------------------------------------------------------------------

    // -------------------------------------------------------------------------------
    public XMLCommonBaseEventLoader() {
        super();
        cdataMap = new HashMap();
    }

    //~ Methods ------------------------------------------------------------------------------------

    // ------------------------------------------------------------------------------------
    public void addAttribute(String name, String value) {
    	if(collectXML)
    	{
    		xmlCollector.addAttribute(name,value);
    		return;
    	}
    	
    	if (currentChild != null) {
            tempObject = currentChild;
        } else {
            tempObject = rootElement;
        }

        if (tempObject == correlationEngine) {
            if (name.equals("id")) {
                try {
                    CorrelationEngine engine = correlationContainer.getCorrelationContainerProxy().getCorrelationEngine();

                    if ((engine != correlationEngine) && !engine.getId().equals(value)) {
                        updateCorrelationContainer(value);
                    }
                } catch (Exception e) {
                    updateCorrelationContainer(value);
                }
            } else if (name.equals("name")) {
                correlationEngine.setName(value);
            } else if (name.equals("type")) {
                correlationEngine.setType(value);
            }

            return;
        }
        else if(tempObject == situation)
        {
        	if(name.equals("categoryName"))
        	{
        		try {
        			situation = (CBESituation)CBEFactory.eINSTANCE.create((EClass)CBEPackage.eINSTANCE.getEClassifier("CBE"+value));
				} catch (Exception e) {
				}
        		situation.setCategoryName(value);
        		rootElement.setSituation(situation);
        		return;
        	}
        	else if(name.equals("xsi:type"))
        	{	
        		try {
        			if(!situation.eClass().getName().equals("CBE"+value))
        			{
        				CBESituation newSituation = (CBESituation)CBEFactory.eINSTANCE.create((EClass)CBEPackage.eINSTANCE.getEClassifier("CBE"+value));
        				newSituation.setCategoryName(situation.getCategoryName());
        				newSituation.setCategoryName(situation.getReasoningScope());
        				rootElement.setSituation(newSituation);
        				situation = newSituation;
        			}
        		} catch (Exception e) {
        			// ignore and leave the default type/settings
        		}
        		return;
        	}
        	else if(name.equals("xmlns:xsi"))
        	{
        		// ignore "xmlns:xsi" attributes
        		return;
        	}
        }
        else if(tempObject == rootElement)
        {	
        	if(name.equals("situationType"))
        	{
        		// TODO: MS add support for CBE 1.0 - situationType
        	}
        }        

        if (cAtt != null) {
            if (cAtt.getName().equals("msgCatalogTokens") && name.equals("value")) {
                EList atts = (EList) currentChild.eGet(cAtt);

                atts.add(value);
            } else {
                if (cAtt.isMany()) {
                    ((EList) tempObject.eGet(cAtt)).add(EcoreUtil.createFromString((EDataType) cAtt.getEType(), value));
                } else {
                    if (!cAtt.getName().equals("creationTime")) {
                        tempObject.eSet(cAtt, EcoreUtil.createFromString((EDataType) cAtt.getEType(), value));
                    } else {
                        setCreationTime(value);
                    }
                }
            }

            return;
        } else {
            EStructuralFeature feature;

            feature = tempObject.eClass().getEStructuralFeature(name);

            if (feature == null) {
                if (tempObject == correlationContainer) {
                    if (name.equals("associationEngine")) {
                        CorrelationContainerProxy correlationContainerProxy = LoadersUtils.getInternalCorrelationContainerProxy(context.getAgentProxy(), value);

                        if (correlationContainer.getCorrelationContainerProxy() == null) {
                            correlationContainerProxy.setCorrelationContainer((CorrelationContainer) tempObject);
                            LoadersUtils.createCorrelationContainerResource(context.getAgentProxy(), value, (CorrelationContainer) tempObject, "internalcc");
                        } else if (correlationContainer.getCorrelationContainerProxy() != correlationContainerProxy) {
                            correlationContainer = HierarchyFactory.eINSTANCE.createCorrelationContainer();
                            correlationContainerProxy.setCorrelationContainer(correlationContainer);
                            LoadersUtils.createCorrelationContainerResource(context.getAgentProxy(), value, correlationContainer, "internalcc");
                        }

                        if (correlationContainerProxy.getCorrelationEngine() == null) {
                            addForwardReference(correlationContainerProxy, HierarchyPackage.eINSTANCE.getCorrelationContainerProxy_CorrelationEngine(), value);
                        }

                        return;
                    } else if (name.equals("resolvedEvents")) {
                        if (associationEngineID == null) {
                            resolvedEvents = value;
                        } else {
                            processResolvedEvents(value);
                        }

                        return;
                    }
                }

                addUnknownAttribute(name, value);

                return;
            } else {
                if (feature instanceof EAttribute) {
                    if (!feature.getName().equals("creationTime")) {
                        Object newValue = EcoreUtil.createFromString((EDataType) feature.getEType(), value);

                        if (newValue != null) {
                            tempObject.eSet(feature, newValue);
                        }
                    } else {
                        setCreationTime(value);
                    }

                    return;
                } else if (feature instanceof EReference) {
                    addForwardReference((EReference) feature, value);

                    return;
                }
            }
        }

        addUnknownAttribute(name, value);
    }

    public void addCharacters(char[] data, int offset, int length) {
    	if(collectXML)
    	{
    		xmlCollector.addCharacters(data,offset,length);
    		return;
    	}
        if (currentChild == null) {
            values = (StringBuffer) cdataMap.get(rootElement);
        } else {
            values = (StringBuffer) cdataMap.get(currentChild);
        }

        if (values == null) {
            values = new StringBuffer();

            if (currentChild == null) {
                cdataMap.put(rootElement, values);
            } else {
                cdataMap.put(currentChild, values);
            }
        }

        values.append(data, offset, length);
    }

    public void addYourselfInContext() {

        context.getAgent().getDefaultEvents().add(rootElement);

        processForwardReferences(rootElement.getGlobalInstanceId(), rootElement);
    }

    /*
     * (non-Javadoc)
     *
     * @see org.eclipse.hyades.loaders.util.XMLFragmentLoader#cleanUp()
     */
    public void cleanUp() {
        super.cleanUp();
        xmlCollector.cleanUp();
        xmlCollector = null;
        cAtt = null;
        cdataMap = null;
        currentChild = null;
        rootElement = null;
        tempObject = null;
        values = null;
    }

    public void endChild(String name) {
    	if (tempObject == correlationEngine) {
    		if (correlationEngine.getId()==null) {
    			correlationEngine.setId(correlationEngine.getType());
    			try {
    				CorrelationEngine engine = correlationContainer.getCorrelationContainerProxy().getCorrelationEngine();

    				if ((engine != correlationEngine) && !engine.getId().equals(correlationEngine.getId())) {
    					updateCorrelationContainer(correlationEngine.getId());
    				}
    			} catch (Exception e) {
    				updateCorrelationContainer(correlationEngine.getId());
    			}
    		}
    	}
    	else
    	if(currentChild == correlationEngine)
    	{
    		StringBuffer nameSB = (StringBuffer)cdataMap.get(correlationEngine);
    		if(nameSB!=null)
    		{
    			correlationEngine.setName(nameSB.toString());
    			correlationEngine.setType(nameSB.toString());
				correlationEngine.setId(correlationEngine.getType());
				try {
					CorrelationEngine engine = correlationContainer.getCorrelationContainerProxy().getCorrelationEngine();
	
					if ((engine != correlationEngine) && !engine.getId().equals(correlationEngine.getId())) {
						updateCorrelationContainer(correlationEngine.getId());
					}
				} catch (Exception e) {
					updateCorrelationContainer(correlationEngine.getId());
				}
    		}
    	}
    	if(collectXML)
    	{
       		xmlCollector.endChild(name);

    		if(xmlCollector.done())
    		{
    			EStructuralFeature sf = currentChild.eClass().getEStructuralFeature(xmlCollector.getTargetFeatureName());
    			if (sf.isMany()) {
    				((EList) currentChild.eGet(sf)).add(EcoreUtil.createFromString((EDataType) sf.getEType(), xmlCollector.getTargetFeatureValue()));
    			} else {
    				currentChild.eSet(sf, EcoreUtil.createFromString((EDataType) sf.getEType(), xmlCollector.getTargetFeatureValue()));
    			}
    			collectXML = false;
    			currentChild = (EObject) pop();
    		}
   			return;
    	}
    	
    	if (size() > 0) {
        	if (resolvedEvents != null) {
                processResolvedEvents(resolvedEvents);
                resolvedEvents = null;
            }

            values = (StringBuffer) cdataMap.get(currentChild);

            if (values != null) {
                String value = values.toString().trim();

                if (value.length() > 0) {
                    if (cAtt != null) {
                        addAttribute("value", value);
                    }
                }

                cdataMap.remove(currentChild);
            }

            currentChild = (EObject) pop();
        }
    }

    public void initialize(HierarchyContext context, String name) {
        super.initialize(context, name);
        cdataMap.clear();
        cAtt = null;

        rootElement = CBEFactory.eINSTANCE.createCBECommonBaseEvent();
        rootElement.setExtensionName("CBE" + name);
        currentChild = null;
        situation = CBEFactory.eINSTANCE.createCBESituation();
        correlationEngine = null;
        collectXML=false;
        values=null;
        clear();
    }

    public void startChild(String name) {
    	if(collectXML)
    	{
    		xmlCollector.startChild(name);
    	}
    	else
    	{	
	        push(currentChild);
	        currentChild = createElementOrAttributeOfCurrentChild(name);
    	}
    }

    private void setCreationTime(String value) {
        rootElement.setCreationTime(LoadersUtils.convertCreationTime(value));
        rootElement.setTimeZone(LoadersUtils.getDeltaTimeZoneInMinutesFromCIMFormat(value));
    }

    private void addForwardReference(EReference feature, String value) {
        int index = 0;
        int prevIndex = 0;

        index = value.indexOf(" ");

        for (; index > 0; index = value.indexOf(" ", prevIndex)) {
            super.addForwardReference(tempObject, feature, value.substring(prevIndex, index));
            prevIndex = index + 1;
        }

        super.addForwardReference(tempObject, feature, value.substring(prevIndex));
    }

    private void addUnknownAttribute(String name, String value) {
    	if(checkAnyData(name,value))
    		return;
        CBEDefaultElement currentAttribute = CBEFactory.eINSTANCE.createCBEDefaultElement();

        currentAttribute.setName(name);
        currentAttribute.getValues().add(value);

        if (tempObject instanceof CBEExtendedDataElement || tempObject instanceof CBEDefaultElement) {
            ((CBEDefaultElement) tempObject).getChildren().add(currentAttribute);
        } else {
            rootElement.getExtendedProperties().add(currentAttribute);
        }

        return;
    }

    private EObject createElementOrAttributeOfCurrentChild(String name) {
        if (currentChild != null) {
            tempObject = currentChild;
        } else {
            tempObject = rootElement;
        }

        EStructuralFeature feature;

        if (name.equals("extendedDataElements")) {
            feature = tempObject.eClass().getEStructuralFeature("extendedProperties");
        } else if (name.equals("associatedEvents")) {
            cAtt = null;
            resolvedEvents = null;
            associationEngineID = null;

            return correlationContainer;
        } else if (name.equals("associationEngineInfo")) {
            cAtt = null;
            correlationEngine = HierarchyFactory.eINSTANCE.createCorrelationEngine();
//            correlationEngine.setCorrelationContainerProxy(correlationContainer.getCorrelationContainerProxy());
            return correlationEngine;
        } else if (name.equals("associationEngine")) {
            cAtt = null;
            correlationEngine = HierarchyFactory.eINSTANCE.createCorrelationEngine();
//            correlationEngine.setCorrelationContainerProxy(correlationContainer.getCorrelationContainerProxy());
            return correlationEngine;
        } else if (name.equals("situation")) {
           	cAtt = null;
           	return situation;
        } else if(name.equals("situationType"))
        {
        	cAtt=null;
    		if(situation instanceof CBEOtherSituation)
    		{
    			collectXML = true;
    			xmlCollector.initialize(context,"anyData");
    		}
    		return situation;
        }else
        {
            feature = tempObject.eClass().getEStructuralFeature(name);
        }

        if (feature == null) {
        	if(checkAnyData(name,null))
        		return tempObject;
            newCurrentChild = CBEFactory.eINSTANCE.createCBEDefaultElement();
            ((CBEDefaultElement) newCurrentChild).setName(name);

            if (tempObject instanceof CBECommonBaseEvent) {
                rootElement.getExtendedProperties().add(newCurrentChild);
            }

            cAtt = null;

            //			cRef=null;
        } else {
            if (feature instanceof EAttribute) {
                newCurrentChild = tempObject;
                cAtt = (EAttribute) feature;
            } else {
                cAtt = null;

                if (feature.getName().equals("contextDataElements")) {
                    newCurrentChild = CBEFactory.eINSTANCE.createCBEContextDataElement();
                    rootElement.getContextDataElements().add(newCurrentChild);
                } else 	if (feature.getName().equals("situation")) {
					newCurrentChild = situation;
                } else if (feature.getName().equals("extendedProperties")) {
                    newCurrentChild = CBEFactory.eINSTANCE.createCBEExtendedDataElement();
                    rootElement.getExtendedProperties().add(newCurrentChild);
                } else if (feature.getName().equals("msgDataElement")) {
                    newCurrentChild = CBEFactory.eINSTANCE.createCBEMsgDataElement();
                    rootElement.setMsgDataElement((CBEMsgDataElement) newCurrentChild);
                } else if (feature.getName().equals("reporterComponentId")) {
                    newCurrentChild = CBEFactory.eINSTANCE.createCBEComponentIdentification();
                    rootElement.setReporterComponentId((CBEComponentIdentification) newCurrentChild);
                } else if (feature.getName().equals("sourceComponentId")) {
                    newCurrentChild = CBEFactory.eINSTANCE.createCBEComponentIdentification();
                    rootElement.setSourceComponentId((CBEComponentIdentification) newCurrentChild);
                } else if (feature.getName().equals("children")) {
                    newCurrentChild = CBEFactory.eINSTANCE.createCBEExtendedDataElement();

                    if ((currentChild != null) && (currentChild instanceof CBEExtendedDataElement || currentChild instanceof CBEDefaultElement)) {
                        ((CBEDefaultElement) currentChild).getChildren().add(newCurrentChild);
                    } else {
                        rootElement.getExtendedProperties().add((CBEExtendedDataElement) newCurrentChild);
                    }
                }
            }
        }

        return newCurrentChild;
    }

    /**
	 * @return
	 */
	private boolean checkAnyData(String name, String value) {
		if(tempObject instanceof CBEOtherSituation)
		{
			collectXML = true;
			xmlCollector.initialize(context,"anyData");
//			xmlCollector.startChild(name);
			return true;
		}
		else if(tempObject instanceof CBECommonBaseEvent)
		{
			if(name.equals("situationType"))
			{
				return false;
			}
			else
			{
				collectXML = true;
				xmlCollector.initialize(context,"otherData");
//				xmlCollector.startChild(name);
			}
			return true;
		}
		return false;
	}

	private void processResolvedEvents(String value) {
        int index = 0;
        int prevIndex = 0;
        
        index = value.indexOf(" ");
		
        if(index<0)
        	index = value.length();

        String cVal;

        for (; index > 0; index = value.indexOf(" ", prevIndex)) {
            cVal = value.substring(prevIndex, index);

            CBECommonBaseEvent cbe = (CBECommonBaseEvent) LookupServiceExtensions.getInstance().locate(context, CBECommonBaseEventImpl.class, LoadersUtils.getLookUpKey(cVal));

            if (cbe != null) {
                EList list = ((EList) correlationContainer.getCorrelations().get(rootElement));

                if (list == null) {
                    list = new BasicEList();
                    list.add(cbe);
                    correlationContainer.getCorrelations().put(rootElement, list);
                } else {
                    list.add(cbe);
                }
            } else {
                // TODO: MS add resolve support for this kind of
                // forward reference
                // adds a map entry reference, the context ID
                // is a concatenation of key.ID+"->"+value.ID
                super.addForwardReference(correlationContainer, HierarchyPackage.eINSTANCE.getCorrelationEntry_Value(), rootElement.getGlobalInstanceId() + "->" + value);
            }

            prevIndex = index + 1;
        }
    }

    /**
     *
     */
    private void updateCorrelationContainer(String correlationID) {
        CorrelationContainerProxy ccp = correlationContainer.getCorrelationContainerProxy();

        if (ccp == null) {
            ccp = LoadersUtils.getInternalCorrelationContainerProxy(context.getAgentProxy(), correlationID);

            if ((correlationContainer.getCorrelations() != null) && (correlationContainer.getCorrelations().size() > 0)) {
                ccp.getCorrelationContainer().getCorrelations().addAll(correlationContainer.getCorrelations());
            }
            correlationContainer.setCorrelationContainerProxy(ccp);
            LoadersUtils.createCorrelationContainerResource(context.getAgentProxy(),correlationID,correlationContainer,"internalcc");
        }
        ccp.setCorrelationEngine(correlationEngine);
    }
}
