/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: CBECommonBaseEvent.java,v 1.10 2005/05/09 05:05:15 slavescu Exp $
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.cbe;

import org.eclipse.emf.common.util.EList;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Common Base Event</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * This class provides the the basic level of common properties for all problem 
 * artifacts.
 * 
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.cbe.CBECommonBaseEvent#getLocalInstanceId <em>Local Instance Id</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.cbe.CBECommonBaseEvent#getGlobalInstanceId <em>Global Instance Id</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.cbe.CBECommonBaseEvent#getCreationTime <em>Creation Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.cbe.CBECommonBaseEvent#getAdjustedCreationTime <em>Adjusted Creation Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.cbe.CBECommonBaseEvent#getTimeZone <em>Time Zone</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.cbe.CBECommonBaseEvent#getSeverity <em>Severity</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.cbe.CBECommonBaseEvent#getPriority <em>Priority</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.cbe.CBECommonBaseEvent#getMsg <em>Msg</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.cbe.CBECommonBaseEvent#getRepeatCount <em>Repeat Count</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.cbe.CBECommonBaseEvent#getElapsedTime <em>Elapsed Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.cbe.CBECommonBaseEvent#getSequenceNumber <em>Sequence Number</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.cbe.CBECommonBaseEvent#getVersion <em>Version</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.cbe.CBECommonBaseEvent#getOtherData <em>Other Data</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.cbe.CBECommonBaseEvent#getContextDataElements <em>Context Data Elements</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.cbe.CBECommonBaseEvent#getReporterComponentId <em>Reporter Component Id</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.cbe.CBECommonBaseEvent#getSourceComponentId <em>Source Component Id</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.cbe.CBECommonBaseEvent#getMsgDataElement <em>Msg Data Element</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.cbe.CBECommonBaseEvent#getSituation <em>Situation</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.models.cbe.CBEPackage#getCBECommonBaseEvent()
 * @model 
 * @generated
 */
public interface CBECommonBaseEvent extends CBEDefaultEvent{
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String copyright = "";

	/**
	 * Returns the value of the '<em><b>Local Instance Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Local Instance Id</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Source supplied event identifier. There is no guarantee that this value is globally unique and stays constant for the life of the event.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Local Instance Id</em>' attribute.
	 * @see #setLocalInstanceId(String)
	 * @see org.eclipse.hyades.models.cbe.CBEPackage#getCBECommonBaseEvent_LocalInstanceId()
	 * @model 
	 * @generated
	 */
	String getLocalInstanceId();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.cbe.CBECommonBaseEvent#getLocalInstanceId <em>Local Instance Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Local Instance Id</em>' attribute.
	 * @see #getLocalInstanceId()
	 * @generated
	 */
	void setLocalInstanceId(String value);

	/**
	 * Returns the value of the '<em><b>Global Instance Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Global Instance Id</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * A globally unique identifier for this specific Event instance.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Global Instance Id</em>' attribute.
	 * @see #setGlobalInstanceId(String)
	 * @see org.eclipse.hyades.models.cbe.CBEPackage#getCBECommonBaseEvent_GlobalInstanceId()
	 * @model 
	 * @generated
	 */
	String getGlobalInstanceId();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.cbe.CBECommonBaseEvent#getGlobalInstanceId <em>Global Instance Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Global Instance Id</em>' attribute.
	 * @see #getGlobalInstanceId()
	 * @generated
	 */
	void setGlobalInstanceId(String value);

	/**
	 * Returns the value of the '<em><b>Creation Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Creation Time</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The time the artifact was created as defined by CIM datetime  data type.  If not defined then the event receiver must timestamp it. 
	 * 
	 * Following is excerpt regarding format is from the standard:
	 * 
	 * yyyymmddhhmmss.mmmmmmsutc  (Must always be 25 characters - zero-padded if necessary)
	 * 
	 * yyyy is a 4 digit year
	 * mm is the month
	 * dd is the day
	 * hh is the hour
	 * mm is the minutes
	 * ss is the second
	 * mmmmmm is the number of microseconds
	 * s is a "+" or "-" indicating the sign of UTC (Universal Coordinate Time - same as Greenwich Mean Time) or simply a ":" indicating a time interval (in case of using : yymm are interpreted as days)
	 * utc is the offset from UTC in minutes and ignored for the time interval
	 * 
	 * For example 19980525145013.0000000-300 is Monday, May 25, 1998 at 2:50:13 PM EST.
	 * 
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Creation Time</em>' attribute.
	 * @see #setCreationTime(double)
	 * @see org.eclipse.hyades.models.cbe.CBEPackage#getCBECommonBaseEvent_CreationTime()
	 * @model 
	 * @generated
	 */
	double getCreationTime();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.cbe.CBECommonBaseEvent#getCreationTime <em>Creation Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Creation Time</em>' attribute.
	 * @see #getCreationTime()
	 * @generated
	 */
	void setCreationTime(double value);

	/**
	 * Returns the value of the '<em><b>Adjusted Creation Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This is used only in XMI case to be able to use the adjusted time in the query engine
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Adjusted Creation Time</em>' attribute.
	 * @see org.eclipse.hyades.models.cbe.CBEPackage#getCBECommonBaseEvent_AdjustedCreationTime()
	 * @model transient="true" changeable="false" volatile="true" derived="true"
	 * @generated
	 */
	double getAdjustedCreationTime();

	/**
	 * Returns the value of the '<em><b>Time Zone</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Time Zone</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The time zone part from the original XML fragment (eg. -240), see creationTime.
	 * 
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Time Zone</em>' attribute.
	 * @see #setTimeZone(short)
	 * @see org.eclipse.hyades.models.cbe.CBEPackage#getCBECommonBaseEvent_TimeZone()
	 * @model 
	 * @generated
	 */
	short getTimeZone();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.cbe.CBECommonBaseEvent#getTimeZone <em>Time Zone</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Time Zone</em>' attribute.
	 * @see #getTimeZone()
	 * @generated
	 */
	void setTimeZone(short value);

	/**
	 * Returns the value of the '<em><b>Severity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Severity</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Events can be classified with different severity levels. This enables administrators to focus on the most severe problems currently occurring in the enterprise. The event adapter can optionally assign the value for this attribute. If the event adapter does not assign a severity level, the default severity level in the event class definition is assigned by the event server. This attribute is extensible; you can add a new severity level by appending to the severities list defined in the event class definition files. The predefined severity levels, in order of increasing severity, are as follows: Information
	 * "	Unknown
	 * "	Harmless error that has no effect on the resource
	 * "	Warning should be used when it's appropriate to let the user decide if action is needed.
	 * "	Minor should be used to indicate action is needed, but the situation is not serious at this time.
	 * "	Critical should be used to indicate action is needed NOW and the scope is broad (perhaps an imminent outage to a critical resource will result).
	 * "	Fatal should be used to indicate an error occurred, but it's too late to take remedial action.
	 * Enumeration values start at 0 and go to 60. Default is unknown (10)
	 * 
	 * Default value is Unknown.
	 * 
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Severity</em>' attribute.
	 * @see #setSeverity(short)
	 * @see org.eclipse.hyades.models.cbe.CBEPackage#getCBECommonBaseEvent_Severity()
	 * @model 
	 * @generated
	 */
	short getSeverity();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.cbe.CBECommonBaseEvent#getSeverity <em>Severity</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Severity</em>' attribute.
	 * @see #getSeverity()
	 * @generated
	 */
	void setSeverity(short value);

	/**
	 * Returns the value of the '<em><b>Priority</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Priority</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Defines the importance of the event
	 * "	Unknown
	 * "	Ignore
	 * "	Low
	 * "	Medium
	 * "	High
	 * "	Critical
	 * 
	 * Default value is Unknown.
	 * 
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Priority</em>' attribute.
	 * @see #setPriority(short)
	 * @see org.eclipse.hyades.models.cbe.CBEPackage#getCBECommonBaseEvent_Priority()
	 * @model 
	 * @generated
	 */
	short getPriority();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.cbe.CBECommonBaseEvent#getPriority <em>Priority</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Priority</em>' attribute.
	 * @see #getPriority()
	 * @generated
	 */
	void setPriority(short value);

	/**
	 * Returns the value of the '<em><b>Msg</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Msg</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The content of this optional string is determined by the event creator. A typical usage would be the fully resolved and human readable message associated with this event.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Msg</em>' attribute.
	 * @see #setMsg(String)
	 * @see org.eclipse.hyades.models.cbe.CBEPackage#getCBECommonBaseEvent_Msg()
	 * @model 
	 * @generated
	 */
	String getMsg();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.cbe.CBECommonBaseEvent#getMsg <em>Msg</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Msg</em>' attribute.
	 * @see #getMsg()
	 * @generated
	 */
	void setMsg(String value);

	/**
	 * Returns the value of the '<em><b>Repeat Count</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Repeat Count</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This optional property is the number of occurrences of a given message artifact for a specific time interval.  The Time interval is indicated by the ElapsedTime property described below.     
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Repeat Count</em>' attribute.
	 * @see #setRepeatCount(short)
	 * @see org.eclipse.hyades.models.cbe.CBEPackage#getCBECommonBaseEvent_RepeatCount()
	 * @model 
	 * @generated
	 */
	short getRepeatCount();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.cbe.CBECommonBaseEvent#getRepeatCount <em>Repeat Count</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Repeat Count</em>' attribute.
	 * @see #getRepeatCount()
	 * @generated
	 */
	void setRepeatCount(short value);

	/**
	 * Returns the value of the '<em><b>Elapsed Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Elapsed Time</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This optional property is the time interval or the elapsed time for the number occurrences of message artifact provided by the MessageCount property.  This property is expressed in microseconds. 
	 * 
	 * 
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Elapsed Time</em>' attribute.
	 * @see #setElapsedTime(long)
	 * @see org.eclipse.hyades.models.cbe.CBEPackage#getCBECommonBaseEvent_ElapsedTime()
	 * @model 
	 * @generated
	 */
	long getElapsedTime();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.cbe.CBECommonBaseEvent#getElapsedTime <em>Elapsed Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Elapsed Time</em>' attribute.
	 * @see #getElapsedTime()
	 * @generated
	 */
	void setElapsedTime(long value);

	/**
	 * Returns the value of the '<em><b>Sequence Number</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Sequence Number</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Optional sequnce numbers are used to provide order at a greater granularity than the time stamps.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Sequence Number</em>' attribute.
	 * @see #setSequenceNumber(long)
	 * @see org.eclipse.hyades.models.cbe.CBEPackage#getCBECommonBaseEvent_SequenceNumber()
	 * @model 
	 * @generated
	 */
	long getSequenceNumber();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.cbe.CBECommonBaseEvent#getSequenceNumber <em>Sequence Number</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Sequence Number</em>' attribute.
	 * @see #getSequenceNumber()
	 * @generated
	 */
	void setSequenceNumber(long value);

	/**
	 * Returns the value of the '<em><b>Version</b></em>' attribute.
	 * The default value is <code>"commonbaseevent1_0"</code>.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Version</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Version</em>' attribute.
	 * @see #setVersion(String)
	 * @see org.eclipse.hyades.models.cbe.CBEPackage#getCBECommonBaseEvent_Version()
	 * @model default="commonbaseevent1_0"
	 * @generated
	 */
	String getVersion();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.cbe.CBECommonBaseEvent#getVersion <em>Version</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Version</em>' attribute.
	 * @see #getVersion()
	 * @generated
	 */
	void setVersion(String value);

	/**
	 * Returns the value of the '<em><b>Other Data</b></em>' attribute list.
	 * The list contents are of type {@link java.lang.String}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Other Data</em>' attribute list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Other Data</em>' attribute list.
	 * @see org.eclipse.hyades.models.cbe.CBEPackage#getCBECommonBaseEvent_OtherData()
	 * @model type="java.lang.String"
	 * @generated
	 */
	EList getOtherData();

	/**
	 * Returns the value of the '<em><b>Context Data Elements</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.cbe.CBEContextDataElement}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Context Data Elements</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Context Data Elements</em>' containment reference list.
	 * @see org.eclipse.hyades.models.cbe.CBEPackage#getCBECommonBaseEvent_ContextDataElements()
	 * @model type="org.eclipse.hyades.models.cbe.CBEContextDataElement" containment="true"
	 * @generated
	 */
	EList getContextDataElements();

	/**
	 * Returns the value of the '<em><b>Reporter Component Id</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Reporter Component Id</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Reporter Component Id</em>' containment reference.
	 * @see #setReporterComponentId(CBEComponentIdentification)
	 * @see org.eclipse.hyades.models.cbe.CBEPackage#getCBECommonBaseEvent_ReporterComponentId()
	 * @model containment="true"
	 * @generated
	 */
	CBEComponentIdentification getReporterComponentId();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.cbe.CBECommonBaseEvent#getReporterComponentId <em>Reporter Component Id</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Reporter Component Id</em>' containment reference.
	 * @see #getReporterComponentId()
	 * @generated
	 */
	void setReporterComponentId(CBEComponentIdentification value);

	/**
	 * Returns the value of the '<em><b>Source Component Id</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Source Component Id</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Source Component Id</em>' containment reference.
	 * @see #setSourceComponentId(CBEComponentIdentification)
	 * @see org.eclipse.hyades.models.cbe.CBEPackage#getCBECommonBaseEvent_SourceComponentId()
	 * @model containment="true" required="true"
	 * @generated
	 */
	CBEComponentIdentification getSourceComponentId();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.cbe.CBECommonBaseEvent#getSourceComponentId <em>Source Component Id</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Source Component Id</em>' containment reference.
	 * @see #getSourceComponentId()
	 * @generated
	 */
	void setSourceComponentId(CBEComponentIdentification value);

	/**
	 * Returns the value of the '<em><b>Msg Data Element</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Msg Data Element</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Msg Data Element</em>' containment reference.
	 * @see #setMsgDataElement(CBEMsgDataElement)
	 * @see org.eclipse.hyades.models.cbe.CBEPackage#getCBECommonBaseEvent_MsgDataElement()
	 * @model containment="true"
	 * @generated
	 */
	CBEMsgDataElement getMsgDataElement();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.cbe.CBECommonBaseEvent#getMsgDataElement <em>Msg Data Element</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Msg Data Element</em>' containment reference.
	 * @see #getMsgDataElement()
	 * @generated
	 */
	void setMsgDataElement(CBEMsgDataElement value);

	/**
	 * Returns the value of the '<em><b>Situation</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Situation</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Situation</em>' containment reference.
	 * @see #setSituation(CBESituation)
	 * @see org.eclipse.hyades.models.cbe.CBEPackage#getCBECommonBaseEvent_Situation()
	 * @model containment="true"
	 * @generated
	 */
	CBESituation getSituation();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.cbe.CBECommonBaseEvent#getSituation <em>Situation</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Situation</em>' containment reference.
	 * @see #getSituation()
	 * @generated
	 */
	void setSituation(CBESituation value);

} // CBECommonBaseEvent
