/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SDBResourceSetImpl.java,v 1.4 2005/02/16 22:21:26 qiyanli Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.models.internal.sdb.impl;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;
import org.eclipse.hyades.models.internal.sdb.util.IUnresolvedResourceHelper;


/**
 * This class allows the definition of
 * <p>
 * 1. The singleton to be used by the clients<p>
 * 2. The <code>URIConverter</code> - it must use ZipWorkbenchURIConverter<p>
 * 3. The use of the <code>PerftraceReosurceFactory</code> as the factory for the Agent resources.
 * This factory will handle the definition of keys to be used during the data load process.
 * 4. The Unresolved resource helper
 */
public class SDBResourceSetImpl extends ResourceSetImpl {
    //~ Static fields/initializers -----------------------------------------------------------------

    private static SDBResourceSetImpl instance;

    //~ Instance fields ----------------------------------------------------------------------------

    private IUnresolvedResourceHelper helper;

    //~ Constructors -------------------------------------------------------------------------------

    public SDBResourceSetImpl() {
        super();
    }

    //~ Methods ------------------------------------------------------------------------------------

    public static SDBResourceSetImpl getInstance() {
        if (instance == null) {
            instance = new SDBResourceSetImpl();

            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("trcdbxmi", new SDBResourceFactoryImpl());
        }

        return instance;
    }

    /**
     * If an object is not found with the given uri, load the
     * resource that has it.
     */
    public EObject getObjectAndLoad(URI uri) throws WrappedException {
        EObject obj = null;

        try {
            obj = super.getEObject(uri, true);
        } catch (WrappedException e) {
            if (helper != null) {
                helper.uriException(uri, (Exception) e);
            }

            /* EC: let mof takes care of the rest */
            throw e;
        }

        return obj;
    }

    public IUnresolvedResourceHelper getUnresolvedException() {
        return helper;
    }

    public void setUnresolvedResourceHelper(IUnresolvedResourceHelper helper) {
        this.helper = helper;
    }

    public Resource makeResource(String uriPath, EList extent) {
        return makeResource(new Path(uriPath), extent);
    }

    public Resource makeResource(IPath uriPath, EList extent) {
        /* opensrc
           Resource resource =
                   EMFWorkbenchPlugin.getResourceHelper().makeResource(
                           uriPath.toString(),
                           extent,
                           getProjectFromURI(uriPath));
           return resource;
         */
        return null;
    }

    /**
     * @generated
     */
    protected static SDBResourceSetImpl getInstanceGen() {
        if (instance == null) {
            instance = new SDBResourceSetImpl();

            instance.setURIConverter(new URIConverterImpl());
        }

        return instance;
    }

    /**
     * If an object is not found with the given uri, load the
     * resource that has it.
     */
    protected EObject getObjectAndLoadGen(URI uri) throws WrappedException {
        EObject obj = null;

        try {
            obj = super.getEObject(uri, true);
        } catch (WrappedException e) {
            if (helper != null) {
                helper.uriException(uri, (Exception) e);
            }

            /* EC: let mof takes care of the rest */
            throw e;
        }

        return obj;
    }

    protected IProject getProjectFromURI(IPath uriPath) {
        IResource container = ResourcesPlugin.getWorkspace().getRoot().findMember(uriPath.removeLastSegments(1));

        if (container != null) {
            return container.getProject();
        }

        return null;
    }

    /**
     * @generated
     */
    protected IUnresolvedResourceHelper getUnresolvedExceptionGen() {
        return helper;
    }

    /**
     * @generated
     */
    protected void setUnresolvedResourceHelperGen(IUnresolvedResourceHelper helper) {
        this.helper = helper;
    }
}
