/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestgenPlugin.java,v 1.7 2005/04/22 14:52:44 bjiang Exp $
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.testgen;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.internal.execution.testgen.TestGeneratorFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;

/**
 * The main Testgen plugin
 * @author Ernest Jessee
 */
public class TestgenPlugin extends AbstractUIPlugin {
	public static final String PLUGIN_ID = "org.eclipse.hyades.execution.testgen"; //$NON-NLS-1$
	/**
	 * The default instance of this plugin
	 */
	private static TestgenPlugin plugin;
	private ResourceBundle resourceBundle;
	
	/**
	 * preference store keys
	 */
	public static final String TEST_GENERATOR="default_test_generator"; //$NON-NLS-1$
	//public static final String SELECTED_GENERATOR="selected_generator";	 //$NON-NLS-1$
	
	/**
	 * The constructor.
	 */
	public TestgenPlugin() {
		super();
		plugin = this;

	}

	/**
	 * Returns the shared instance.
	 */
	public static TestgenPlugin getDefault() {
		return plugin;
	}

	/**
	 * Returns the workspace instance.
	 */
	public static IWorkspace getWorkspace() {
		return ResourcesPlugin.getWorkspace();
	}

	/**
	 * Returns the string from the plugin's resource bundle,
	 * or 'key' if not found.
	 */
	public static String getResourceString(String key) {
		ResourceBundle bundle= TestgenPlugin.getDefault().getResourceBundle();
		try {
			return bundle.getString(key);
		} catch (MissingResourceException e) {
			return key;
		}
	}

	/**
	 * Returns the plugin's resource bundle,
	 */
	private ResourceBundle getResourceBundle()
	{
		if(resourceBundle == null)
		{
		
			try
			{
				resourceBundle = Platform.getResourceBundle(Platform.getBundle(PLUGIN_ID));
			}
			catch (Exception e) {
				resourceBundle = null;
			}
		}
		
		return resourceBundle;
	}

	/**
	 * acquires a reference to a plugin preference specified by "key"
	 * @param key
	 * @return
	 */
	public static String getPreference(String key)
	{
		return getDefault().getPreferenceStore().getString(key);
	}
		
	
	
	/**
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#initializeDefaultPreferences(org.eclipse.jface.preference.IPreferenceStore)
	 */
	protected void initializeDefaultPreferences(IPreferenceStore store)
	{
		
		store.setDefault(TestgenPlugin.TEST_GENERATOR,getDefaultGeneratorID()); //$NON-NLS-1$
		
	}

	public String getDefaultGeneratorID()
	{
		//find all registered generators, select the highest priority
		String[] ids = TestGeneratorFactory.getInstance().getGeneratorIDs();
		String defaultID = "org.eclipse.hyades.execution.testgen.TestGenGenerator.HTTPGenerator";
		int nMax = -1;
		for (int i = 0; i < ids.length; i++)
		{
			if (TestGeneratorFactory.getInstance().getGeneratorPriority(ids[i]) > nMax)
				defaultID = ids[i];
		}
		return defaultID;	
	}

}
