/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: HttpGenerator.java,v 1.5 2005/05/03 22:52:27 jptoomey Exp $
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.http.internal.codegen;

import java.io.ByteArrayInputStream;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;

import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.test.common.internal.codegen.Helper;
import org.eclipse.hyades.test.common.internal.codegen.JavaGenerator;

/**
 * @author marcelop
 * @since 1.0.2
 */
public class HttpGenerator 
extends JavaGenerator
{
	/**
	 * @see org.eclipse.hyades.test.common.internal.codegen.Generator#generateFile(org.eclipse.hyades.models.common.facades.behavioral.ITestSuite, org.eclipse.core.resources.IFile, org.eclipse.core.runtime.IProgressMonitor)
	 */
	protected void generateFile(ITestSuite testSuite, IFile file, IProgressMonitor monitor)
	throws Exception
	{
		GenTestSuite genTestSuite = new GenTestSuite();
		String content = Helper.formatContent(genTestSuite.generate(testSuite, new Helper()));	
		// use UTF-8 encoding - bugzilla_88029 running test with non-ASCII characters.
		file.create(new ByteArrayInputStream(content.getBytes(CHARSET_UTF8)), true, monitor);
		file.setCharset(CHARSET_UTF8, monitor);
	}
}
