/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: HttpGenerateWizard.java,v 1.6 2005/03/16 13:13:15 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.test.http.internal.junit.wizard;

import org.eclipse.hyades.test.common.TestCommonPlugin;
import org.eclipse.hyades.test.common.internal.codegen.Generator;
import org.eclipse.hyades.test.http.TestHttpPlugin;
import org.eclipse.hyades.test.http.internal.codegen.HttpGenerator;
import org.eclipse.hyades.test.java.TestJavaPlugin;
import org.eclipse.hyades.test.java.internal.junit.wizard.GenerateWizard;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;

public class HttpGenerateWizard 
extends GenerateWizard
{
	/**
	 * @see org.eclipse.hyades.test.java.internal.junit.wizard.GenerateWizard#createGenerator()
	 */
	protected Generator createGenerator()
	{
		return new HttpGenerator();
	}
	
	/**
	 * @see org.eclipse.hyades.test.java.internal.junit.wizard.GenerateWizard#addRequiredLibraries(org.eclipse.hyades.test.common.internal.codegen.Generator)
	 */
	protected void addRequiredLibraries(Generator generator)
	{
		HttpGenerator httpGenerator = (HttpGenerator)generator;
		httpGenerator.addAllLibraries(PLUGIN_ID_JUNIT);
		httpGenerator.addRequiredLibrary(TestCommonPlugin.getID(), "common.runner.jar");
		httpGenerator.addRequiredLibrary(TestHttpPlugin.getID(), "http.runner.jar");
	}
	
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.java.internal.junit.wizard.GenerateWizard#confirmOverwrite()
	 */
	protected boolean confirmOverwrite() {
		MessageDialog dialog = new MessageDialog(
				getShell(), TestJavaPlugin.getString("W_QUESTION"),  //$NON-NLS-1$
				null, TestHttpPlugin.getString("Q_OVR_FILE"),  //$NON-NLS-1$
				MessageDialog.QUESTION, 
				new String[] {IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1);
		return dialog.open() == IDialogConstants.OK_ID;
	}
}