/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: HttpTestCaseNewWizard.java,v 1.6 2005/02/16 22:21:43 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.http.internal.junit.wizard;

import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.test.common.TestCommon;
import org.eclipse.hyades.test.common.internal.wizard.TestCaseNewWizard;
import org.eclipse.hyades.test.http.TestHttpImages;
import org.eclipse.hyades.test.http.TestHttpPlugin;

/**
 * Wizard for the JUnit Test Case
 * 
 * @author marcelop
 * @since 0.3.0
 */
public class HttpTestCaseNewWizard
extends TestCaseNewWizard
{
	/**
	 * Constructor for TestCaseNewWizard
	 */
	public HttpTestCaseNewWizard()
	{
		super();

		setWindowTitle(TestHttpPlugin.getString("WIZ_TST_CASE_TTL")); //$NON-NLS-1$
		setDefaultPageImageDescriptor(TestHttpImages.INSTANCE.getImageDescriptor(TestHttpImages.IMG_WIZBAN_NEW_HTTP_TESTCASE));
	}

	/**
	 * Returns the type for the test case created by this wizard.
	 * @return String
	 */
	protected String getType()
	{
		return TestCommon.HTTP_JUNIT_TEST_CASE_TYPE;
	}
	
	/**
	 * @see org.eclipse.jface.wizard.IWizard#addPages()
	 */
	public void addPages()
	{
        ITestSuite testSuite = getTestSuite();
        String label = testSuite != null ? testSuite.getName() : ""; //$NON-NLS-1$

        getNameAndDescriptionWizardPage().setTitle(TestHttpPlugin.getString("WIZ_TST_CASE_TTL")); //$NON-NLS-1$
        getNameAndDescriptionWizardPage().setDescription(TestHttpPlugin.getString("WIZ_TST_CASE_GEN_PG_ATT_DSC", label)); //$NON-NLS-1$
		addPage(getNameAndDescriptionWizardPage());
	}
}
