/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: HTTPReportGenerator.java,v 1.7 2005/04/25 13:44:35 jptoomey Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.http.internal.reports;

import java.util.List;

import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.util.ExecutionUtil;
import org.eclipse.hyades.test.http.junit.TypeValidator;
import org.eclipse.hyades.test.ui.navigator.ITestCaseProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITestSuiteProxyNode;
import org.eclipse.hyades.ui.report.IReportGenerator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;

/**
 * Abstract object to be extended by HTTP report generators
 * @author Ernest Jessee
 */
public abstract class HTTPReportGenerator implements IReportGenerator 
{

	protected IStructuredSelection selection;

	protected TPFTest test=null;
	
	protected TPFExecutionResult result = null;
	
	private List results;

	
	public void setUsedClasspath(String arg0)
	{
	}

	/**
	 * returns the file extension for the report to be generated.
	 */
	public String getReportFileExtension(ISelection arg0)
	{
		return "html";
	}

	/**
	 * returns a boolean indicating whether or not this report generator is avalable.	 * 
	 * @param ISelection theSel
	 */
	public boolean isAvailable(ISelection theSel)  
	{		
		if(theSel instanceof IStructuredSelection)
		{
			selection = (IStructuredSelection)theSel;
			Object element = ((IStructuredSelection)theSel).getFirstElement();
			
			if(element instanceof ITestSuiteProxyNode)
				test = ((ITestSuiteProxyNode)element).getTestSuite();
			else if(element instanceof ITestCaseProxyNode)
				test = ((ITestCaseProxyNode)element).getTestCase();
			else if(element instanceof TPFTest)
				test = (TPFTest)element;
			else
				return false;
					
			if(!new TypeValidator().isValidType(test.getType()))
				return false;
			results = ExecutionUtil.findExecutionResults(test);	
			return (results.size()>0);
		}
		return false;
	}

	/**
	 * initialzes the TPFExecutionResult object
	 *
	 */
	protected void initResultSelection()
	{
		
		 if(results.size()>1)
		 {
			 ResultsSelectionWizard wiz = new ResultsSelectionWizard(results);
			 new WizardDialog(Display.getDefault().getActiveShell(),wiz).open();			
			 result=wiz.getSelectedResult();
		 }
		 else if(results.size()==1)
		 {
		 	result = (TPFExecutionResult)results.get(0);
		 }
		 else
			result = null;
		 	
	}

}
