/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: HitRateReport.java,v 1.7 2005/02/16 22:21:43 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.http.internal.reports.hitrate;

import java.util.Iterator;

import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionType;
import org.eclipse.hyades.models.common.testprofile.TPFMessageEvent;
import org.eclipse.hyades.models.common.testprofile.TPFTypedEvent;
import org.eclipse.hyades.test.http.internal.reports.HttpAbstractReport;
import org.eclipse.hyades.test.http.internal.reports.responsetime.ResponseTimeReport;

/**
 * 
 * @author Ernest Jessee
 * @author jnevicos
 */
public class HitRateReport extends HttpAbstractReport
{
 
	protected long startTime=-1;
	protected long stopTime=-1;

	/**
	 * 
	 */
	public HitRateReport(TPFExecutionResult result) {
		super(result);
	}

	protected void finishReport()
	{
		if (list.size() > 1) //don't add overall if less than 2 elements
		{
			HitRateData.setTestElapsedTime(stopTime-startTime);
			list.add(new HitRateData.OverallHitRate());
		}
	}

	protected void setupReport() 
	{
		HitRateData.resetCounter();
	}
	
	protected void processMessageEvent(TPFMessageEvent event)
	{						
		String message = event.getText();
				
				
		int responseTimeIndex = message.indexOf(responseTimeMarker); 
		if(responseTimeIndex!=-1)
		{
			String pageName = message.substring(message.indexOf(pageNameMarker)+ResponseTimeReport.pageNameMarker.length(),responseTimeIndex).trim();
			String responseTime = message.substring(responseTimeIndex+responseTimeMarker.length(),message.length());
			responseTime=responseTime.substring(0,responseTime.indexOf(lf)).trim();
					
					
			HitRateData hitRateData = (HitRateData) findPage(pageName);
			if(hitRateData==null)						
			{
				hitRateData = new HitRateData(pageName);
				list.add(hitRateData);
			}
			hitRateData.addHit(new Long(responseTime).longValue());				
		}
		
	}

	protected void processTypedEvent(TPFTypedEvent typedEvent)
	{
		if(typedEvent.getType()==TPFExecutionType.STOP_LITERAL)
		{
			stopTime = typedEvent.getTimestamp();
		}
		else if(startTime==-1)
		{
			startTime=typedEvent.getTimestamp();
		}						
	}



}
