/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ResponseTimeData.java,v 1.5 2005/02/16 22:21:43 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.http.internal.reports.responsetime;

import org.eclipse.hyades.test.http.internal.reports.IReportGraphDataProvider;

/**
 * @author amathur
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class ResponseTimeData implements IReportGraphDataProvider 
{
	private static int cumulativeCounter = 0;
	private static double cumulativeResponseTime=0.0;
	
	String id = null;
	double responseTime = 0.0;
	long count = 0;

	static class OverallResponseTime implements IReportGraphDataProvider
	{
	
		
		public String getId()
		{
		
			return "Overall Average";
		}

		
		public String getValue()
		{
		
			return ResponseTimeData.getOverallAvarageResponseTime();
		}

	}
	
	/**
	 * 
	 */
	public ResponseTimeData(String id) 
	{
		this.id = id;
	}

	
	public void addSample(long time)
	{
		responseTime+=time/1000.0;
		cumulativeResponseTime+=time/1000.0;
		count++;
		cumulativeCounter++;
	}
	
	

	/**
	 * @return
	 */
	public static void resetCumulativeValues() 
	{
		cumulativeCounter = 0;
		cumulativeResponseTime=0;
	}
	
	/**
	 * @return
	 */
	public String getId() {
		return id;
	}

	public double getAverageResponseTime()
	{
		if (count == 0)
			return 0;
		return new Double(responseTime/count).doubleValue();
	}
	
	public static String getOverallAvarageResponseTime()
	{
		return new Double(cumulativeResponseTime/new Long(cumulativeCounter).doubleValue()).toString();
	}
	
	

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.http.internal.reports.IReportGraphDataProvider#getValue()
	 */
	public String getValue()
	{
		return new Double(getAverageResponseTime()).toString();
	}

}
